#include <stdio.h>
#include "defs.h"
#include "exts.h"

int valopen ;
int upvalopen ;

setup_val( val ) struct dvalue *val ; {
 char dline[BUFSIZ] ;
 float dx, dy ;
 double tick, delta ;
    if ( valopen ) {
	delete_retained_segment( VAL ) ;
	valopen = 0 ;
    }
    if ( val->kind & IVAL )
	set_valuator( 1, (float) *val->iptr, val->vmin, val->vmax ) ;
    if ( val->kind & FVAL )
	set_valuator( 1, *val->fptr, val->vmin, val->vmax ) ;
    set_linewidth( .5 ) ;
    create_retained_segment( VAL ) ;
    move_abs_2( xmin, valbot ) ;
    line_abs_2( xmax, valbot ) ;
    line_abs_2( xmax, valtop ) ;
    line_abs_2( xmin, valtop ) ;
    line_abs_2( xmin, valbot ) ;
    set_linewidth( 0. ) ;
    inquire_charsize( &dx, &dy ) ;
    dx *= 3./4. ;
    dy *= 3./4. ;
    set_charsize( dx, dy ) ;
    set_charup_2( 1., 0. ) ;
    set_charpath_2( 0., -1. ) ;
    set_tick( val->vmin, val->vmax, &tick, &delta ) ;
    while ( tick < val->vmax ) {
	if ( fabs( tick ) < 1.e-6 )
	    tick = 0. ;
	sprintf( dline, "%g", tick ) ;
	move_abs_2( map(tick,val->vmin,val->vmax,xmin,xmax), valbot ) ;
	line_rel_2( 0., -.03 ) ;
	move_rel_2( 0., -.01 ) ;
	text( dline ) ;
	tick += delta ;
    }
    sprintf( dline, "%g", val->vmin ) ;
    move_abs_2( fx(0), valbot ) ;
    line_rel_2( 0., -.03 ) ;
    move_rel_2( 0., -.01 ) ;
    text( dline ) ;
    sprintf( dline, "%g", val->vmax ) ;
    move_abs_2( fx(1.), valbot ) ;
    line_rel_2( 0., -.03 ) ;
    move_rel_2( 0., -.01 ) ;
    text( dline ) ;
    set_charup_2( 0., 1. ) ;
    set_charpath_2( 1., 0. ) ;
    dx *= 4./3. ;
    dy *= 4./3. ;
    set_charsize( dx, dy ) ;
    close_retained_segment() ;
    valopen = 1 ;
    update_val( val ) ;
}
update_val( val ) struct dvalue *val ; {
 char txt[BUFSIZ] ;
 int newdis, vis ;
    newdis = 0 ;
    if ( !( val->kind & NVAL ) ) {
	if ( val->kind & IVAL ) {
	    if ( *val->iptr != val->idval ) {
		sprintf( txt, "%d", *val->iptr ) ;
		val->idval = *(val->iptr) ;
		newdis = 1 ;
	    }
	} else if ( val->kind & FVAL ) {
	    if ( *(val->fptr) != val->fdval ) {
		sprintf( txt, "%.5g", *(val->fptr) ) ;
		val->fdval = *(val->fptr) ;
		newdis = 1 ;
	    }
	} else if ( val->kind & SVAL ) {
	    sprintf( txt, "%s", val->sptr ) ;
	    newdis = 1 ;
	}
	if ( newdis ) {
	    inquire_segment_visibility( val->valseg, &vis ) ;
	    delete_retained_segment( val->valseg ) ;
	    create_retained_segment( val->valseg ) ;
	    set_segment_visibility( val->valseg, vis ) ;
	    move_abs_2( val->valx, val->valy ) ;
	    text( txt ) ;
	    close_retained_segment() ;
	}
    }
    if ( upvalopen ) {
	delete_retained_segment( UPVAL ) ;
	upvalopen = 0 ;
    }
    if ( valopen ) {
     float x ;
     int i ;
	create_retained_segment( UPVAL ) ;
	if ( !strcmp( val->name, "begin time" ) ) {
	    x = map(((float)begin+wsize),val->vmin,val->vmax,xmin,xmax) ;
	    move_abs_2( x, valbot ) ;
	    line_abs_2( x, valtop ) ;
	    for ( i = 1 ; i < niter ; i++ ) {
		x = 
		  map(((float)begin+wsize+i*skip),val->vmin,val->vmax,xmin,xmax) ;
		move_abs_2( x, valbot ) ;
		line_abs_2( x, valtop ) ;
	    }
	}
	if ( val->kind & IVAL ) {
	    x = map(((float)*val->iptr),val->vmin,val->vmax,xmin,xmax) ;
	    move_abs_2( x, valbot ) ;
	    line_abs_2( x, valtop ) ;
	} else if ( val->kind & FVAL ) {
	    x = map(*val->fptr,val->vmin,val->vmax,xmin,xmax) ;
	    move_abs_2( x, valbot ) ;
	    line_abs_2( x, valtop ) ;
	}
	close_retained_segment() ;
	upvalopen = 1 ;
    }
}
setdown_val() {
    if ( valopen ) {
	delete_retained_segment( VAL ) ;
	valopen = 0 ;
    }
    if ( upvalopen ) {
	delete_retained_segment( UPVAL ) ;
	upvalopen = 0 ;
    }
}
select_for_update( val ) struct dvalue *val ; {
    if ( val->kind & FVAL ) {
	if ( val->fptr != fptr ) {
	    fptr = val->fptr ;
	    setup_val( val ) ;
	}
    } else if ( val->kind & IVAL ) {
	if ( val->iptr != iptr ) {
	    iptr = val->iptr ;
	    setup_val( val ) ;
	}
    } else {
	fptr = NULL ;
	iptr = NULL ;
	setdown_val() ;
    }
}
