#include <stdio.h>
#include <math.h>
#include "defs.h"
#include "exts.h"

typedef struct { float re ; float im ; } complex ;
complex cadd(), csub(), cmult(), scmult(), cdiv(), conjg(), csqrt() ;

complex zero = { 0., 0. } ; ;
complex one = { 1., 0. } ;

#define DH 4

makedis( fp, srate, B, W, S, I, P, xfm, smin, smax )
 FILE *fp ; float srate, *smin, *smax ; int B, W, S, I, P, xfm ;
{
 int i, j, iter, k, n, LO ;
 char *malloc(), *calloc(), txt[BUFSIZ] ;
 float value, rms, peak, lpa(), lpamp() ;
 static float **s, *lpcoef, *window, *buf, *x, *y, *z, Lsrate ;
 static complex *pole ;
 static int N ;
/*
 * initialize 
 */
    for ( i = 2 ; 1 ; i <<= 1 )
	if ( i >= W ) {
	    N = i ;
		break ;
	}
    if ( xfm & PRESP )
	if ( npresp > N )
	    N = npresp ;
    s = (float **) malloc( I*sizeof(float *) ) ;
    for ( iter = 0 ; iter < I ; iter++ )
	s[iter] = (float *) calloc( N+2, sizeof(float) ) ;
    lpcoef = (float *) malloc( (P+1)*sizeof(float *) ) ;
    pole = (complex *) malloc( P*sizeof(complex) ) ;
    window = (float *) malloc( W*sizeof(float) ) ;
    buf = (float *) calloc( (N+1), sizeof(float) ) ;
    x = (float *) calloc( (N + 1 + DH), sizeof(float) ) ;
    y = (float *) calloc( (N + 1 + DH), sizeof(float) ) ;
    z = (float *) calloc( (N + 1 + DH), sizeof(float) ) ;

    for ( i = 0 ; i < W ; i++ ) {
     double fac = 8.*atan( 1. )/( W - 1. ) ;
	window[i] = .54 - .46*cos( fac*i ) ;
    }
/*
* apply specified transformations
*/
    for ( iter = 0 ; iter < I ; iter++ ) {
	fseek( fp, (B+iter*S)*sizeof(float), 0 ) ;
	k = fread( s[iter], sizeof(float), W, fp ) ;
	if ( k < W )
	    sclear( s[iter] + k, W - k ) ;
	if ( W < N )
	    sclear( s[iter] + W, N - W ) ;
/*
* optional Hamming window
*/
	if ( xfm & HAMMING )
	    smult( s[iter], s[iter], window, W ) ;
    }
/*
* optional linear prediction
*/
    if ( P ) {
	for ( iter = 0 ; iter < I ; iter++ ) {
	    lpcoef[0] = lpa( s[iter], W, lpcoef, P ) ;
	    if ( xfm & PRESP ) {
	     float pfac = 4.*atan(1.)/npresp ;
	     float afac = 4./W ;
		if ( I > 1 )
		    z[0] = iter/(I - 1.) - .5 ;
		else
		    z[0] = 0 ;
		for ( i = 0 ; i <= npresp ; i++ ) {
		    s[iter][i] = afac*lpamp( i*pfac, lpcoef[0], lpcoef, P ) ;
		}
		if ( xfm & ( DBSPEC | ZDBSPEC ) )
		    sadb( s[iter], s[iter], npresp+1 ) ;
		continue ;
	    }
	    lpresp( s[iter], W, lpcoef, P ) ;
	    if ( xfm & POLES ) {
		findpoles( lpcoef, pole, P ) ;
		if ( I > 1 )
		    z[0] = iter/(I - 1.) - .5 ;
		else
		    z[0] = 0 ;
		move_abs_3( .5, 0., z[0] ) ;
#define CS 100
		for ( i = 1 ; i <= CS ; i++ ) {
		 double f = 8.*atan(1.)/CS ;
		    line_abs_3( .5*cos( i*f ), .5*sin( i*f ), z[0] ) ;
		}
		move_abs_3( -.5, 0., z[0] ) ;
		line_abs_3( .5, 0., z[0] ) ;
		move_abs_3( 0., -.5, z[0] ) ;
		line_abs_3( 0., .5, z[0] ) ;
		for ( i = 0 ; i < P ; i++ ) {
		    pole[i].re *= .5 ; pole[i].im *= .5 ;
		    move_abs_3( pole[i].re, pole[i].im, z[0] ) ;
		    move_rel_3( -.015, -.015, 0. ) ;
		    line_rel_3( .03, .03, 0. ) ;
		    move_rel_3( 0., -.03, 0. ) ;
		    line_rel_3( -.03, .03, 0. ) ;
		}
	    }
	}
	if ( xfm & POLES ) {
	    *smin = -1. ; *smax = 1. ;
	    for ( i = 0 ; i < I ; i++ )
		free( s[i] ) ;
	    free( s ) ;
	    free( lpcoef ) ;
	    free( pole ) ;
	    free( window ) ;
	    free( buf ) ;
	    free( x ) ;
	    free( y ) ;
	    free( z ) ;
	    return ;
	}
    }
/*
* optional rms or peak amplitude computation
*/
    if ( xfm & RMS ) {
	for ( iter = 0 ; iter < I ; iter++ ) {
	    srms( &value, s[iter], W ) ;
	    for ( i = 0 ; i < W ; i++ )
		s[iter][i] = value ;
	}
    } else if ( xfm & PEAK ) {
	for ( iter = 0 ; iter < I ; iter++ ) {
	    speak( &value, s[iter], W ) ;
	    for ( i = 0 ; i < W ; i++ )
		s[iter][i] = value ;
	}
    }
/*
* optionally compute various transformations
*/
    if ( xfm & FFT && !( xfm & PRESP ) ) {
	for ( iter = 0 ; iter < I ; iter++ ) {
	    if ( xfm & HPSPEC )
		srms( &rms, s[iter], W ) ;
	    rfft( s[iter], N>>1, 1 ) ;
	    if ( !( xfm & FILT ) && !( xfm & HPSPEC ) )
		sscale( s[iter], 1./N, N ) ;
	    s[iter][N] = s[iter][1] ;
	    s[iter][N+1] = s[iter][1] = 0. ;
	    if ( xfm & PHASPEC ) {
		spha( s[iter], s[iter], (N>>1)+1 ) ;
		continue ;
	    }
	    ssmsq( s[iter], s[iter], (N>>1)+1 ) ;
	    if ( xfm & AMPSPEC )
		ssqrt( s[iter], s[iter], (N>>1)+1 ) ;
	    if ( xfm & ( DBSPEC | ZDBSPEC ) )
		spdb( s[iter], s[iter], (N>>1)+1 ) ;
	    if ( xfm & HPSPEC ) {
		scopy( buf, s[iter], (N>>1)+1 ) ;
		for ( i = 1 ; i < (N>>1)+1 ; i++ ) {
		    for ( s[iter][i] = buf[i], j = 2 ; j <= nharm ; j++ ) {
			if ( j*i < (N>>1)+1 )
			    s[iter][i] *= buf[j*i] ;
			else
			    s[iter][i] = 0. ;
		    }
		}
		s[iter][0] = 0. ;
		speak( &peak, s[iter], (N>>1)+1 ) ;
		if ( peak != 0. )
		    sscale( s[iter], rms/peak, (N>>1)+1 ) ;
	    }
	}
    }

/*
 * find extrema in data to be displayed
 */
    *smin = *smax = s[0][dxmin] ;
    for ( iter = 0 ; iter < I ; iter++ ) {
	for ( i = dxmin ; i <= dxmax ; i++ ) {
	    if ( s[iter][i] > *smax )
		*smax = s[iter][i] ;
	    if ( s[iter][i] < *smin )
		*smin = s[iter][i] ;
	}
    }
    if ( *smax == *smin ) {
	if ( *smin < 0. )
	    *smax = 0. ;
	else if ( *smax > 0. )
	    *smin = 0. ;
	else {
	    *smin = -1. ;
	    *smax = 1. ;
	}
    }
/*
 * set up normalized display (runs from -.5 to .5 in all dimensions)
 */
/* for polygons, draw slices in reverse */
    for ( iter = 0 ; iter < I ; iter++ ) {
	if ( dxmax - dxmin > 0 ) {
	    x[0] = x[1] = .5 ; x[2] = x[3] = -.5 ;
	} else
	    x[0] = x[1] = x[2] = x[3] = 0. ;
	y[0] = map(s[iter][dxmax],*smin,*smax,-.5,.5) ;
	y[1] = y[2] = -.5 ;
	y[3] = map(s[iter][dxmin],*smin,*smax,-.5,.5) ;
	if ( I > 1 )
	    z[0] = z[1] = z[2] = z[3] = iter/(I - 1.) - .5 ;
	else
	    z[0] = z[1] = z[2] = z[3] = 0. ;
	for ( LO = dxmax - dxmin + 1, j = 0, i = dxmin ; i <= dxmax ; i++ ) {
	    if ( dxmax - dxmin > 0 )
		x[j+DH] = map(((float)i),((float)dxmin),((float)dxmax),-.5,.5) ;
	    else
		x[j+DH] = 0. ;
	    y[j+DH] = map(s[iter][i],*smin,*smax,-.5,.5) ;
	    z[j+DH] = z[0] ;
/*
 * horizontal optimization
 */
	    if (
		y[j+DH] == y[j+DH-1] &&
		y[j+DH-1] == y[j+DH-2] &&
		i > dxmin &&
		i < dxmax
	    ) {
		x[j+DH-1] = x[j+DH] ;
		LO-- ;
	    } else
		j++ ;
	}
/* for polygons, use thick outlines
	set_linewidth( 1. ) ;
*/
	polyline_abs_3( &x[dof], &y[dof], &z[dof], LO + DH - dof ) ;
/* draw polygons
	set_linewidth( 0. ) ;
	polygon_abs_3( &x[dof], &y[dof], &z[dof], LO + DH  - dof ) ;
*/
    }
    for ( i = 0 ; i < I ; i++ )
	free( s[i] ) ;
    free( s ) ;
    free( lpcoef ) ;
    free( pole ) ;
    free( window ) ;
    free( buf ) ;
    free( x ) ;
    free( y ) ;
    free( z ) ;
}
