#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <sunwindow/window_hs.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sun/fbio.h>
#include <usercore.h>
#include <signal.h>

#include "exts.h"

int bw2dd() ;
struct vwsurf rawsurface = DEFAULT_VWSURF( bw2dd ) ;
int pixwindd() ;
struct vwsurf windowsurface = DEFAULT_VWSURF( pixwindd ) ;
struct vwsurf *surface ;
char *getenv() ;

setup_core( ) {
 int _core_winsig() ;
    if ( getenv( "WINDOW_ME" ) )
	surface = &windowsurface ;
    else
	surface = &rawsurface ;
    if ( initialize_core( DYNAMICB, SYNCHRONOUS, THREED ) )
	exit( 1 ) ;
    if( get_view_surface( surface, NULL ) )
	exit( 2 ) ;
    if ( initialize_view_surface( surface, FALSE ) )
	exit( 3 ) ;
    if ( select_view_surface( surface ) )
	exit( 4 ) ;
    set_ndc_space_3( ndcx, ndcy, ndcz ) ;        /* optional adjustment */
    set_output_clipping( TRUE ) ;
    set_charprecision( CHARACTER ) ;
    set_font( STICK ) ;

    initialize_device( BUTTON, 1) ;
    initialize_device( BUTTON, 2) ;
    initialize_device( BUTTON, 3) ;
    initialize_device( KEYBOARD, 1);
    initialize_device( LOCATOR, 1);
    initialize_device( PICK, 1 ) ;
    initialize_device( STROKE, 1);
    initialize_device( VALUATOR, 1) ;

    set_echo_surface( KEYBOARD, 1, surface ) ;
    set_echo_surface( LOCATOR, 1, surface ) ;
    set_echo_surface( PICK, 1, surface ) ;
    set_echo_surface( STROKE, 1, surface ) ;
    set_echo_surface( VALUATOR, 1, surface ) ;

    set_echo_position( KEYBOARD, 1, .17, .03 ) ;
    set_echo_position( LOCATOR, 1, .5, .5 ) ;
    set_echo_position( PICK, 1, .5, .5 ) ;
    set_echo_position( STROKE, 1, .5, .5 ) ;
    set_echo_position( VALUATOR, 1, .5, 0. ) ;

    set_echo( KEYBOARD, 1, 1 ) ;
    set_echo( LOCATOR, 1, 1 ) ;
    set_echo( PICK, 1, 1 ) ;
    set_echo( STROKE, 1, 1 ) ;
    set_echo( VALUATOR, 1, 0 ) ;

    signal( SIGWINCH, _core_winsig ) ;
}
setdown_core() {
    delete_all_retained_segments() ;

    terminate_device( BUTTON, 1 ) ;
    terminate_device( BUTTON, 2 ) ;
    terminate_device( BUTTON, 3 ) ;
    terminate_device( KEYBOARD, 1);
    terminate_device( LOCATOR, 1);
    terminate_device( PICK, 1);
    terminate_device( STROKE, 1);
    terminate_device( VALUATOR, 1);

    deselect_view_surface( surface ) ;

    terminate_core() ;
}

static struct vwsurf nullvs = NULL_VWSURF ;

static char *devchk ;
static int devhaswindows ;

get_view_surface( vsptr, argv ) struct vwsurf *vsptr ; char **argv ; {
 int fd, chkdevhaswindows() ;
 char *wptr, dev[DEVNAMESIZE], *getenv() ;
 struct screen screen ;
 struct fbtype fbtype ;

    *vsptr = nullvs ;
    if ( wptr = getenv( "WINDOW_ME" ) ) {
	devhaswindows = TRUE ;
	if ( ( fd = open( wptr, O_RDWR, 0 ) ) < 0 ) {
	    fprintf( stderr, "get_view_surface: Can't open %s\n", wptr ) ;
	    return( 1 ) ;
	}
	win_screenget( fd, &screen ) ;
	close( fd ) ;
	strncpy( dev, screen.scr_fbname, DEVNAMESIZE ) ;
    } else {
	devhaswindows = FALSE ;
	strncpy( dev, "/dev/fb", DEVNAMESIZE ) ;
    }
    if ( ( fd = open( dev, O_RDWR, 0 ) ) < 0 ) {
	fprintf( stderr, "get_view_surface: Can't open %s\n", dev ) ;
	return( 1 ) ;
    }
    if ( ioctl( fd, FBIOGTYPE, &fbtype ) == -1 ) {
	fprintf( stderr,
	    "get_view_surface: ioctl FBIOGTYPE failed on %s\n", dev ) ;
	close( fd ) ;
	return( 1 ) ;
    }
    close( fd ) ;
    if ( devhaswindows ) 
	switch( fbtype.fb_type ) {
	 case FBTYPE_SUN2BW:
	    vsptr->dd = pixwindd ;
	    break ;
	 case FBTYPE_SUN1BW:
	 case FBTYPE_SUN1COLOR:
	 case FBTYPE_SUN2COLOR:
	 case FBTYPE_SUN2GP:
	 default:
	    fprintf( stderr,
		"get_view_surface: unknown fbtype type %s\n", dev ) ;
	    return( 1 ) ;
	}
    else
	switch( fbtype.fb_type ) {
	 case FBTYPE_SUN2BW:
	    vsptr->dd = bw2dd ;
	    break ;
	 case FBTYPE_SUN1BW:
	 case FBTYPE_SUN1COLOR:
	 case FBTYPE_SUN2COLOR:
	 case FBTYPE_SUN2GP:
	 default:
	    fprintf( stderr,
		"get_view_surface: unknown fbtype type %s\n", dev ) ;
	    return( 1 ) ;
	}
    if ( !devhaswindows )
	strncpy( vsptr->screenname, dev, DEVNAMESIZE ) ;
    return( 0 ) ;
}

struct suncore_raster raster ;

struct {
    int type ;
    int nbytes ;
    char *data ;
} rmap ;

int rastf ;

make_dump() {
 int replicate ;
    if ( 
	( rastf = open( "raster.dump", O_WRONLY | O_CREAT | O_TRUNC, 0644 ) ) 
    < 0 ) 
    {
	errmess( "make_dump: 'raster.dump' could not be created" ) ;
    } else {
	size_raster( surface, 0., ndcx, 0., ndcy, &raster ) ;
	allocate_raster( &raster ) ;
	if ( raster.bits == NULL ) {
	    errmess( "make_dump: the raster could not be allocated!" ) ;
	} else {
	    get_raster( surface, 0., ndcx, 0., ndcy, 0, 0, &raster ) ;
	    rmap.type = 0 ;
	    rmap.nbytes = 0 ;
	    replicate = 1 ;
	    raster_to_file( &raster, &rmap, rastf, replicate ) ;
	}
	free_raster( &raster ) ;
	close( rastf ) ;
    }
}
