/****aivar.h***/
/*
 *              Digital Audio Interface
 *
 *                      written by J. M. Roth/R. Gross
 */

/*      %W%     %G%     */

/*
 *      Conversion Parameter Structure -- This data structure is passed
 *      between the kernel (aiioctl) and the user program 
 */

struct aud_conv {
	int a_fd;               /* soundfile file descriptor */
	dev_t a_dev;            /* device (until I see system stuff) */
	int a_flags;            /* misc. flags */
	int a_nbytes;		/* number of bytes to convert */
	int a_numdbs;		/* number of buffers per hardware window */
	int a_nchans;		/* number of channels */
	int a_srate;		/* sampling rate bytes for ds16 */
	int a_scanflag;		/* scan flag; 1 == scan, 0 == noscan */
	int a_bufskip;		/* nbufs to skip from beginning */
	int a_byteskip;		/* nbytes to skip in buf */
	caddr_t user_addr;	/* for "priming" ds16 with data */
	int a_reserved[4];	/* reserved for future compatablility */
};

/*      Internal driver structure for conversion
 *      This structure contains flags that are used to communicate
 *      hardware and software status between the audio interface and
 *      the disk driver.
 */

/* Maximum subdivisions per hardware buffer. When Bank Switch is enabled
   We see only 64k bytes (that is 1/2 of the actual memory) */

#define MAXBLOCKS 1
#define NUMBUFS 26		/* sfl - up from 14 for better thruput */

struct ai_convert {
	int c_fd;
	int c_type;
	long c_xfer_size;                       /* transfer size in bytes   */
	int c_numdbs;                           /* disk blocks per buufer */
	int c_dbsize;                           /* disk block size in bytes  */
	int c_dev;                              /* Disk device used          */
	int c_flags;                            /* Misc. flags  from user    */
	int c_status;                           /* Misc. flags  from system  */
	struct buf c_buf[NUMBUFS][MAXBLOCKS];   /* Buffers for disk transfers */
	struct buf ctrl_buf;			/* buf for ctrl words to ds16 */
	daddr_t *c_blist;                       /* block list    */
	daddr_t *c_curblock;                    /* current block */
	int c_blksdone;
	int c_allocblocks;             		/* Number of Blocks allocated  */
	int c_numblocks;                	/* Number of Blocks in the blocklist  */
	int (*c_strat)();       		/* Device strategy routine */
	int c_offset;           		/* Offset into first playing block */
	int conv_sigs;				/* conversion signals */
	short chandata;				/* channel info */
	short can_scan;				/* buffer is ready for scan */
	int endbufs;				/* Number of bufs to flush */
};
