/* vadconn.c	1.9	(CARL)	7/15/83	10:16:58 */

static char SID_vadconn[] = "@(#)vadconn.c 1.9 (CARL) 7/15/83";

# ifdef VAD
# include <signal.h>
# include <setjmp.h>
# include <errno.h>
# include <sgtty.h>
# include <ctype.h>
# include <time.h>
# include <pwd.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

/*
 * vadic dialer connect routine.
 * only supports the older (va801 type)
 * vadic dialer and not the macs
 * variety
 */

# define STBNULL	((struct sgttyb *) NULL)

/*
 * default speed for vadic
 * dialer
 */
# define VADSPEED	300

/*
 * available devices for a
 * vadic dialer connection
 */
struct conndev vaddev[] = {
	{ "/dev/acu0",	VADSPEED },
	{ 0,		0 }		/* last entry must be zeros */
};

static char vadusage[] = "usage: %s [ -t ] [ -lline ] [ -sspeed ] telno";
static char lfile1[] = "/mnt/adm/culog";
static char lfile2[] = "/tmp/culog";

static char *vaderrs[] = {
	"unable to make connection",
	"unknown error",
	"format error",
	"parity error",
	"phone number too long",
};

static char vadmsgbuf[BUFSIZ];

static jmp_buf sig2jb;
static bool noab = FALSE;

char *
vadconn(ctp, speed, argerr)
struct conntab *ctp;
bool argerr;
{
	extern struct telno *curc();
	extern char *vaddial();
	struct telno *tp;
	char *cp;

	if ((ctp->c_telno == NULL) || argerr) {
		sprintf(vadmsgbuf, vadusage, ctp->c_name);
		return(vadmsgbuf);
	}

	/*
	 * if the phone number contains non-numerics
	 * then it is an alias. '=' is special because
	 * it is used to tell the vadic dialer to wait
	 * for an intermediate dial tone.
	 */
	tp = NULL;
	for (cp = ctp->c_telno; *cp != NULL; cp++) {
		if (! isdigit(*cp)) {
			if (*cp != '=') {
				if ((tp = curc(ctp->c_telno)) == NULL)
					return("bad phone number");
				break;
			}
		}
	}

	/*
	 * no alias, dial the
	 * supplied phone number
	 */
	if (tp == NULL)
		return(vaddial(ctp, speed));

	/*
	 * dial each phone number in the
	 * tp list. when we break out of
	 * the for loop cp will contain
	 * the proper error message.
	 */
	for (;;) {
		ctp->c_telno = tp->t_telno;
		if ((cp = vaddial(ctp, speed)) != vadmsgbuf)
			break;

		if ((tp = tp->t_next) == NULL)
			break;
		else
			diag(cp);
	}

	return(cp);
}

char *
vaddial(ctp, speed)
struct conntab *ctp;
{
	extern int vadreset();
	extern int vadsig2();
	struct conndev *cdp;
	struct sgttyb stbuf;
	int lspeed;
	int oerrno;
	char phbuf[60];
	char *cp;
	char ch;

	signal(SIGINT, vadsig2);
	if (setjmp(sig2jb)) {
		lnclose();
		return("interrupted");
	}

	for (cdp = ctp->c_dev; cdp->d_dev != NULL; cdp++) {
		if (sflg)
			cdp->d_speed = speed;
		if (cdp->d_speed == 0)
			cdp->d_speed = VADSPEED;
		if ((lspeed = spdchk(cdp->d_speed, sflg)) == ERR)
			return("bad speed");

		oerrno = errno;
		if (access(cdp->d_dev, 6) != 0) {
			if (errno == ENOENT)
				errno = oerrno;
			continue;
		}

		if ((ln = open(cdp->d_dev, 2)) != -1)
			break;
	}

	if (cdp->d_dev == NULL)
		return(noaccess(vadmsgbuf, "dialer"));

	if (ln == -1)
		return("dialer in use"); 

	if (ioctl(ln, TIOCEXCL, STBNULL) == -1)
		goto iocerr;
	if (ioctl(ln, TIOCHPCL, STBNULL) == -1)
		goto iocerr;

	if (ioctl(ln, TIOCGETP, &stbuf) == -1)
		goto iocerr;
	stbuf.sg_ispeed = lspeed;
	stbuf.sg_ospeed = lspeed;
	stbuf.sg_flags = (EVENP | ODDP | RAW | (tflg ? TANDEM : 0));
	if (ioctl(ln, TIOCSETP, &stbuf) == -1) {
	iocerr:	lnclose();
		return("ioctl error");
	}

	devreset = vadreset;
	vadreset();

	aculog("%s, ", ctp->c_telno);
	msg("dialing...");

	sprintf(phbuf, "\02%s\017\03", ctp->c_telno);

	if (dflg)
		diag("vaddial: sending to dialer: ");
	for (cp = &phbuf[0]; *cp != NULL; cp++) {
		if (dflg) {
			if ((*cp < ' ') || (*cp > '~'))
				echo("^%c", *cp+'@');
			else
				echo("%c", *cp);
		}
		if (write(ln, cp, CHRSIZ) != CHRSIZ) {
			lnclose();
			aculog("write error\n");
			return("dialer write error");
		}
	}

	if (dflg)
		echo(crlf);

	/*
	 * wait for response from dialer
	 */
	if (dflg)
		diag("vaddial: waiting for response from dialer");

	if (read(ln, &ch, CHRSIZ) != CHRSIZ) {
		lnclose();
		aculog("read error\n");
		return("dialer read error");
	}

	if (ch != 'A') {
		if (dflg)
			diag("vaddial: got \\%03o from dialer", ch);
		lnclose();
		if ((ch < 'A') || (ch > 'F'))
			ch = 'C';
		aculog("dial failed: %s (%c)\n", vaderrs[ch-'A'-1], ch);
		sprintf(vadmsgbuf, "dial failed: %s", vaderrs[ch-'A'-1]);
		return(vadmsgbuf);
	}

	aculog("succeeded\n");

	noab = TRUE;

	return(NULL);
}

static int
vadsig2() {

	(void) signal(SIGINT, SIG_IGN);
	aculog("interrupted\n");
	longjmp(sig2jb, 1);
}

vadreset() {
# ifdef FIONREAD
	long nread;
	char ch;

	if (noab)
		return;

	if (write(ln, "\01", CHRSIZ) != CHRSIZ)
		return;
	sleep(1);

	if (ioctl(ln, FIONREAD, &nread) != -1) {
		while (nread-- > 0) {
			if (read(ln, &ch, CHRSIZ) != CHRSIZ)
				break;
			if (dflg)
				diag("vadreset: flushing char %o", ch);
		}
	}
# endif FIONREAD
}
# endif VAD
