/* %M%	%I%	(CARL)	%G%	%U% */

static char SID_DSWCONN[] = "%Z%%M% %I% (CARL) %G%";

# ifdef DSW
# include <signal.h>
# include <setjmp.h>
# include <sgtty.h>
# include <errno.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

/*
 * develcon dataswitch connect
 * routine
 */

# define STBNULL	((struct sgttyb *) NULL)

/*
 * default speed for dataswitch
 * connection. note this isn't
 * used, it is here for cosmetics.
 */
# define DSWSPEED	2400

# define LDELAY 131072		/* long delay */
# define SDELAY	65536		/* short delay */

/*
 * indices into dswerrs
 */
# define S_BADSYS	0
# define S_INUSE	1
# define S_ACCESS	2
# define S_ERR		3
# define S_BUSY		4
# define S_DEAD		5

# define NDSWNAMES	(sizeof(dswtab) / sizeof(dswtab[0]))

/*
 * the following should be read in
 * from a file.
 *
 * this table maps a "long name"
 * into a dataswitch name. the
 * dataswitch only allows a max
 * 4 chars in a system name.
 */
struct dswtab {
	char	*w_lname;
	char	*w_sname;
	int	w_speed;
} dswtab[] = {
	{ "amos",	"amos",	1200 },
	{ "catt",	"ca",	2400 },
	{ "catta",	"ca",	2400 },
	{ "cattb",	"cb",	2400 },
	{ "eecs",	"eecs",	2400 },
	{ "phonlab",	"pl",	1200 },
	{ "s3",		"s3",	2400 },
	{ "s5",		"s5",	2400 },
	{ "s6",		"s6",	2400 },
	{ "su3",	"s3",	2400 },
	{ "su3",	"su3",	2400 },
	{ "sv2",	"sv2",	2400 },
	{ "dswitch",	NULL,	2400 },		/* should be last */
};

char *dswerrs[] = {
	"bad system",				/* S_BADSYS */
	"dataswitch line in use",		/* S_INUSE */
	"cannot open dataswitch line",		/* S_ACCESS */
	"dataswitch error",			/* S_ERR */
	"no ports",				/* S_BUSY */
	"dataswitch line broken",		/* S_DEAD */
};

/*
 * available devices for a
 * dataswitch connection
 */
struct conndev dswdev[] = {
	{ "/dev/dsw0",	0 },	/* d_speed must be 0 */
	{ 0,		0 }	/* last entry must be zeros */
};

static char dswmsgbuf[BUFSIZ];

static char dswusage[] = "usage: %s [ -t ] [ -w ] [ -lline ] [ -sspeed ] [ -mmach ]";
static char req[] = "Request:\07";
static char trying[] = "Trying";
static char busy[] = "Busy";
static char rs[] = "rs";

static jmp_buf sig14jb;

char *
dswconn(ctp, speed, argerr)
struct conntab *ctp;
bool argerr;
{
	extern char *dswreq();
	struct sgttyb stbuf;
	struct conndev *cdp;
	struct dswtab *dp;
	int lspeed;
	int oerrno;
	char *rmsg;

	if (argerr) {
		sprintf(dswmsgbuf, dswusage, ctp->c_name);
		return(dswmsgbuf);
	}

# ifdef notdef
	/* gross */
	if (ctp->c_telno != NULL) {
		dp = &dswtab[NDSWNAMES-1];
		dp->w_lname = ctp->c_telno;
		dp->w_sname = ctp->c_telno;
		ctp->c_name = ctp->c_telno;
	}
# endif notdef
	if (mflg) {
		dp = &dswtab[NDSWNAMES-1];
		dp->w_lname = ctp->c_name;
		dp->w_sname = ctp->c_name;
	}

	/*
	 * search dswtab until we match the
	 * machine name
	 */
	for (dp = &dswtab[0]; dp < &dswtab[NDSWNAMES]; dp++) {
		if (eql(dp->w_lname, ctp->c_name))
			break;
	}

	/*
	 * didn't find it
	 */
	if (dp == &dswtab[NDSWNAMES])
		return("unknown machine name");

retry:	for (cdp = ctp->c_dev; cdp->d_dev != NULL; cdp++) {
		if (sflg)
			cdp->d_speed = speed;
		if (cdp->d_speed == 0)
			cdp->d_speed = dp->w_speed;
		if ((lspeed = spdchk(cdp->d_speed, sflg)) == ERR)
			return("bad speed");

		oerrno = errno;
		if (access(cdp->d_dev, 6) != 0) {
			if (errno == ENOENT)
				errno = oerrno;
			continue;
		}

		if ((ln = open(cdp->d_dev, 2)) != -1)
			break;
	}

	if (cdp->d_dev == NULL)
		return(noaccess(dswmsgbuf, "dataswitch"));

	if (ln == -1)
		return("dataswitch line in use"); 

	if (ioctl(ln, TIOCEXCL, STBNULL) == -1)
		goto iocerr;
	if (ioctl(ln, TIOCHPCL, STBNULL) == -1)
		goto iocerr;

	/*
	 * get user's tty params and use
	 * them to set params on the
	 * communications line
	 */
	ioctl(fileno(stdout), TIOCGETP, &stbuf);
	stbuf.sg_ispeed = lspeed;
	stbuf.sg_ospeed = lspeed;
	stbuf.sg_flags = (EVENP | ODDP | RAW | (tflg ? TANDEM : 0));
	if (ioctl(ln, TIOCSETP, &stbuf) == -1) {
	iocerr:	lnclose();
		return("ioctl error");
	}

	/*
	 * if the name to send to the
	 * switch is null then don't
	 * do any requesting.
	 */
	if (dp->w_sname == NULL)
		return(NULL);

	/*
	 * sometimes the first "rs" doesn't get any response,
	 * in this case we'll just keep sending one rs after
	 * another until something happens.
	 */
	if ((rmsg = dswreq(dp->w_sname)) == dswerrs[S_DEAD]) {
		lnclose();
		goto retry;
	}

	return(rmsg);
}

/*
 * do the rs and requesting
 * of the system for the
 * user automatically.
 */
char *
dswreq(mach)
char *mach;
{
	extern int dswsig14();
	register char *bp;
	char dswbuf[BUFSIZ];
	char *rmsg;
	char ch;

	rmsg = dswerrs[S_DEAD];

	signal(SIGALRM, dswsig14);
	if (setjmp(sig14jb))
		return(rmsg);

	/*
	 * send out "rs" so dataswitch can
	 * determine our speed
	 */
	bp = &rs[0];
	while (*bp != NULL) {
		delay(LDELAY);
		write(ln, bp, CHRSIZ);
		putc(*bp, stdout);
		bp++;
	}
	fputs(crlf, stdout);

	alarm(10);

	/*
	 * read up everything until
	 * a bell: "request:\07"
	 */
	bp = &dswbuf[0];
	do {
		if (read(ln, &ch, CHRSIZ) != CHRSIZ)
			return(dswerrs[S_ERR]);
		ch &= 0177;
		putc(ch, stdout);
		*bp++ = ch;
		if (bp >= &dswbuf[BUFSIZ])
			return(dswerrs[S_ERR]);
	} while (ch != '\07');
	*bp = NULL;

	if (! eqln(dswbuf, req, strlen(req)))
		return(dswerrs[S_ERR]);

	rmsg = dswerrs[S_ERR];

	alarm(30);

	/*
	 * ask for the system
	 */
	strcpy(dswbuf, mach);
	strcat(dswbuf, crlf);
	bp = dswbuf;
	while (*bp != NULL) {
		delay(SDELAY);
		write(ln, bp, CHRSIZ);
		if (read(ln, &ch, CHRSIZ) != CHRSIZ)	/* echo */
			return(dswerrs[S_ERR]);
		ch &= 0177;
		putc(ch, stdout);
		bp++;
	}

	/*
	 * read up chars spit
	 * out by the switch until
	 * we get a carriage return or bell
	 */
	bp = &dswbuf[0];
	do {
		if (read(ln, &ch, CHRSIZ) != CHRSIZ)
			return(dswerrs[S_ERR]);
		ch &= 0177;
		putc(ch, stdout);
		if ((ch != '\r') && (ch != '\n'))
			*bp++ = ch;
		if (bp >= &dswbuf[BUFSIZ])
			return(dswerrs[S_ERR]);
	} while ((ch != '\n') && (ch != '\07'));
	*bp = NULL;

	alarm(0);
	signal(SIGALRM, SIG_DFL);

	/*
	 * if there was no bell in the
	 * string or the first char is a
	 * query then the requested system
	 * doesn't have any available ports,
	 * or something may be wrong.
	 */
	if ((dswbuf[0] != '\07') || (dswbuf[0] == '?')) {
		/*
		 * check for "busy" message
		 */
		if (eqln(dswbuf, busy, strlen(busy)) || eqln(dswbuf, trying, strlen(trying))) {
			if (wflg)
				return(dswerrs[S_BUSY]);
			else {
				msg("(hit DEL or RUB to abort)");
				do {
					if (read(ln, &ch, CHRSIZ) != CHRSIZ)
						return(dswerrs[S_ERR]);
					ch &= 0177;
					putc(ch, stdout);
				} while (ch != '\07');
			}
		}
		else if (dswbuf[0] == '?') {
			msg("");
			return(dswerrs[S_BADSYS]);
		}
		else
			return(dswerrs[S_ERR]);
	}

# ifdef autocr
	/*
	 * do a cr so that the
	 * system will start
	 * talking to us.
	 */
	delay(LDELAY);
	write(ln, "\r", CHRSIZ);
# endif autocr

	return(NULL);
}

static int
dswsig14() {
	signal(SIGALRM, dswsig14);
	longjmp(sig14jb, 1);
}
# endif DSW
