/* ss_reset.c	1.4	(CARL)	7/24/84	13:01:42 */

# include <vaxuba/asw.h>
# include <sys/file.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
# include "client.h"
# include "clerr.h"
# include "ss_defs.h"
# include "switch.h"
# include "aswdaemon.h"

/*
 * reset routine for
 * cmd smart switcher
 */
ss_reset() {
	int fd;

	debug(DB_DRIVER, "reset:");

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
		err(ERR_DRIVER, "conn: open(%s): %m", sw->sw_devnam);
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	if (ioctl(fd, ASW_RESET, 0) == -1) {
		err(ERR_DRIVER, "reset: ioctl(ASW_RESET): %m");
		client.cl_err = ASW_ERR_DEVIO;
		(void) close(fd);
		return(RET_ERR);
	}

	(void) clrconn();

	close(fd);

	return(RET_OK);
}
