/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include "ss_defs.h"
# include "switch.h"
# include "connlist.h"
# include "numlist.h"
# include "aswdaemon.h"

/*
 * init routine for
 * cmd smart switcher
 */
ss_init() {
	extern int	ss_interval();

	debug(DB_DRIVER, "init:");

	(void) ivadd(ss_interval, "ss_interval");

	return(RET_OK);
}

ss_interval() {
	extern struct connlist		*clget();
	register struct connlist	*tcl;
	register struct numlist		*inl, *onl;

	while ((tcl = clget()) != NULL) {
		if ((inl = maknl(tcl->cl_input, NL_INPUT)) == NULL)
			return(RET_ERR);
		if ((onl = maknl(tcl->cl_output, NL_OUTPUT)) == NULL)
			return(RET_ERR);

		(*sw->sw_conn)(inl, onl);

		freenl(inl);
		freenl(onl);
	}

	return(RET_OK);
}
