/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/file.h>
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
# include "connlist.h"
# include "numlist.h"
# include "ss_defs.h"
# include "client.h"
# include "clerr.h"
# include "switch.h"
# include "aswdaemon.h"

/*
 * disconnect routine for
 * cmd smart switcher
 */
ss_disconn(nl1, nl2)
	struct numlist *nl1;
	struct numlist *nl2;
{
	register struct numlist *tonl, *tinl;
	register struct numlist *inl, *onl;
	register struct connlist *cl;
	short	num;
	int	ret;
	int	fd;

	/* debug(DB_DRIVER, "ss_disconn:"); */

	if ((nl1 == NULL) && (nl2 == NULL)) {
		err(ERR_DRIVER, "ss_disconn: nl1==NULL && nl2==NULL");
		client.cl_err = ASW_ERR_PROG;
		return(RET_ERR);
	}

	if (nl1->nl_type == NL_INPUT) {
		inl = nl1;
		onl = nl2;
	}
	else {
		inl = nl2;
		onl = nl1;
	}

	if (onl->nl_type == inl->nl_type) {
		info(INFO_DRIVER, "ss_disconn: can't disconnect same types");
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}

	if (onl == NULL)
		return(ss_disconn1(inl));

	if (inl == NULL) {
		err(ERR_USER, "ss_disconn: disconnecting only output disallowed");
		client.cl_err = ASW_ERR_CHAN;
		return(RET_ERR);
	}

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
		err(ERR_DRIVER, "ss_disconn: open(%s): %m", sw->sw_devnam);
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

	for (tonl = onl->nl_forw, tinl = inl->nl_forw; (tonl != onl) && (tinl != inl); tonl = tonl->nl_forw, tinl = tinl->nl_forw) {
		/* verify channels */
		if ((tonl->nl_num < SS_MINCHAN) || (tonl->nl_num >= SS_MAXCHAN)) {
			info(INFO_DRIVER, "ss_disconn: invalid output channel (%d)", tonl->nl_num);
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}
		if ((tinl->nl_num < SS_MINCHAN) || (tinl->nl_num >= SS_MAXCHAN)) {
			info(INFO_DRIVER, "ss_disconn: invalid input channel (%d)", tinl->nl_num);
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}

		/*
		 * verify that the input space is really connected
		 * to the output space.
		 */
		if ((cl = isconn(tinl->nl_num, inl->nl_type)) == NULL) {
			err(ERR_DRIVER, "ss_disconn: not connected (%d)", tinl->nl_num);
			client.cl_err = ASW_ERR_NOTCONN;
			continue;
		}
		if (cl->cl_output != tonl->nl_num) {
			err(ERR_DRIVER, "ss_disconn: %d not connected to %d", tinl->nl_num, tonl->nl_num);
			client.cl_err = ASW_ERR_NOTCONN;
			continue;
		}

		num = SS_DISCONN(tonl->nl_num, tinl->nl_num);
		debug(DB_DRIVER, "ss_disconn: %d->%d", tonl->nl_num, tinl->nl_num);

		if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
			err(ERR_DRIVER, "ss_disconn: write: %m");
			client.cl_err = ASW_ERR_DEVIO;
			continue;
		}

		if (delconn(tonl->nl_num, tinl->nl_num) == RET_ERR)
			err(ERR_DRIVER, "ss_disconn: delconn(%d, %d) failed", tinl->nl_num, tonl->nl_num);
	}

	(void) close(fd);

	return(ret);
}

ss_disconn1(nl)
	register struct numlist *nl;
{
	register struct numlist *tnl;
	register struct connlist *cl;
	short	num;
	int	nconns;
	int	ret;
	int	fd;

	/* debug(DB_DRIVER, "ss_disconn1:"); */

	if (nl == NULL) {
		err(ERR_DRIVER, "ss_disconn1: nl==NULL");
		return(RET_ERR);
	}

	if ((fd = open(sw->sw_devnam, O_WRONLY, 0)) == -1) {
		err(ERR_DRIVER, "ss_disconn1: open(%s): %m", sw->sw_devnam);
		client.cl_err = ASW_ERR_DEVIO;
		return(RET_ERR);
	}

	ret = RET_OK;

	for (tnl = nl->nl_forw; tnl != nl; tnl = tnl->nl_forw) {
		/* verify channels */
		if ((tnl->nl_num < SS_MINCHAN) || (tnl->nl_num >= SS_MAXCHAN)) {
			info(INFO_DRIVER, "ss_disconn1: invalid output channel (%d)", tnl->nl_num);
			client.cl_err = ASW_ERR_CHAN;
			continue;
		}

		nconns = 0;

		while ((cl = isconn(tnl->nl_num, nl->nl_type)) != NULL) {
			num = SS_DISCONN(cl->cl_output, cl->cl_input);
			/* debug(DB_DRIVER, "ss_disconn1: num = 0%o (0x%x)", num, num); */
			debug(DB_DRIVER, "ss_disconn1: %d->%d", cl->cl_output, cl->cl_input);

			nconns++;

			if (write(fd, (char *) &num, sizeof(num)) != sizeof(num)) {
				err(ERR_DRIVER, "ss_disconn1: write: %m");
				client.cl_err = ASW_ERR_DEVIO;
				continue;
			}

			if (delconn(cl->cl_output, cl->cl_input) == RET_ERR)
				err(ERR_DRIVER, "ss_disconn1: delconn failed");
		}

		if (nconns == 0) {
			err(ERR_DRIVER, "ss_disconn1: not connected (%d)", tnl->nl_num);
			client.cl_err = ASW_ERR_NOTCONN;
		}
	}

out:	(void) close(fd);

	return(ret);
}
