/* setup.c	1.4	(CARL)	7/24/84	13:41:43 */

# include <sys/file.h>
# include <syslog.h>
# include <sgtty.h>
# include <stdio.h>
# include "switch.h"
# include "aswdaemon.h"

/*
 * setup
 *
 * setup detaches us from all things physical
 * and transmorgifies us into a daemon.
 */
setup() {
	static char logtag[BUFSIZ];
	register int fd;

	if (fork())
		exit(0);

	for (fd = 0; fd < 20; fd++)
		(void) close(fd);

	(void) open("/dev/null", O_RDONLY, 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);

	if ((fd = open("/dev/tty", O_RDWR, 0)) != -1) {
		(void) ioctl(fd, TIOCNOTTY, (char *) 0);
		(void) close(fd);
	}

	strcpy(logtag, "aswdaemon");
	openlog(logtag, LOG_PID);

	setup_done = 1;

	instvar();
	instrw();

	cfget();

# ifdef use_sw_type
	/*
	 * if you call openlog more
	 * than once it should just
	 * reset the ident and logstat
	 * parameters.
	 */
	strcat(logtag, ": ");
	strcat(logtag, sw->sw_type);
	openlog(logtag, LOG_PID);
# endif use_sw_type

	setsigs();

	(*sw->sw_reset)();

	info(INFO_INFO, "setup: aswdaemon started, pid=%d", getpid());
}
