/* parse.y	1.10	(CARL)	4/25/85	11:36:31 */

%{
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
# include "aswdaemon.h"
# include "switch.h"
# include "numlist.h"
# include "symtab.h"
# include "client.h"
# include "clerr.h"

extern int		cfnum;
extern char		cfstr[];
%}

%start	config_file

%token	CF_NUMBER	/* 01234...	*/
%token	CF_IDENT	/* identifier	*/
%token	CF_STRING	/* string	*/

%token	CF_DISCONNECT	/* "disconnect"	*/
%token	CF_CONNECT	/* "connect"	*/
%token	CF_CHANNEL	/* "channel"	*/
%token	CF_OUTPUT	/* "output"	*/
%token	CF_INPUT	/* "input"	*/
%token	CF_RESET	/* "reset"	*/
%token	CF_INIT		/* "init"	*/
%token	CF_FROM		/* "from"	*/
%token	CF_DUMP		/* "dump"	*/
%token	CF_SET		/* "set"	*/
%token	CF_USE		/* "use"	*/
%token	CF_IS		/* "is"		*/
%token	CF_TO		/* "to"		*/
%token	CF_EQUAL	/* '='		*/
%token	CF_SEMI		/* ';'		*/
%token	CF_COMMA	/* ','		*/
%token	CF_LBRACK	/* '['		*/
%token	CF_RBRACK	/* ']'		*/

%type	<num_ty>	num
%type	<num_ty>	type
%type	<numlist_ty>	numlist
%type	<numlist_ty>	chan
%type	<string_ty>	ident
%type	<string_ty>	string

%union {
	int			num_ty;
	char			string_ty[BUFSIZ];
	struct numlist *	numlist_ty;
};

%%

config_file:
	file {
		debug(DB_PARSE, "cfparse: config: file");
	};

file:
	file line {
		debug(DB_PARSE, "cfparse: file: file line");
	} |
	error {
		yyerrok;
		yyclearin;
		client.cl_err = ASW_ERR_SYNTAX;
		clerrmsg(0);
		err(ERR_PARSE, "cfparse: file: error");
	} |
	/* empty */ {
		debug(DB_PARSE, "cfparse: file: empty");
	};

line:
	var_assign {
		debug(DB_PARSE, "cfparse: line: var_assign");
	} |
	chan_assign {
		debug(DB_PARSE, "cfparse: line: chan_assign");
		clerrmsg(1);
	} |
	disconnect {
		debug(DB_PARSE, "cfparse: line: disconnect");
		clerrmsg(1);
	} |
	connect {
		debug(DB_PARSE, "cfparse: line: connect");
		clerrmsg(1);
	} |
	reset {
		debug(DB_PARSE, "cfparse: line: reset");
		clerrmsg(1);
	} |
	init {
		debug(DB_PARSE, "cfparse: line: init");
		clerrmsg(1);
	} |
	dump {
		debug(DB_PARSE, "cfparse: line: dump");
		clerrmsg(1);
	};

var_assign:
	CF_SET ident CF_EQUAL num CF_SEMI {
		struct hlist *hl;
		debug(DB_PARSE, "cfparse: var_assign: set ident (%s) = num (%d)", $2, $4);
		info(INFO_PARSE, "cfparse: set %s = %d", $2, $4);
		if ((hl = lookup($2, ST_NVAR)) == NULL) {
			err(ERR_PARSE, "cfparse: var_assign: can't find var %s", $2);
			client.cl_err = ASW_ERR_VAR;
		}
		else
			(void) varset(hl, ST_NVAR, $4);
	} |
	CF_SET ident CF_EQUAL string CF_SEMI {
		struct hlist *hl;
		debug(DB_PARSE, "cfparse: var_assign: set ident (%s) = string (%s)", $2, $4);
		info(INFO_PARSE, "cfparse: set %s = %s", $2, $4);
		if ((hl = lookup($2, ST_SVAR)) == NULL) {
			err(ERR_PARSE, "cfparse: var_assign: can't find var %s", $2);
			client.cl_err = ASW_ERR_VAR;
		}
		else
			(void) varset(hl, ST_SVAR, $4);
	};

chan_assign:
	CF_OUTPUT ident CF_IS numlist CF_SEMI {
		typenl($4, NL_OUTPUT);
		debug(DB_PARSE, "cfparse: chan_assign: output ident (%s) is numlist (%s)", $2, prnumlist($4));
		info(INFO_PARSE, "cfparse: output %s is %s", $2, prnumlist($4));
		(void) install($2, ST_NL_OUTPUT, (char *) $4);
	} |
	CF_INPUT ident CF_IS numlist CF_SEMI {
		typenl($4, NL_INPUT);
		debug(DB_PARSE, "cfparse: chan_assign: input ident (%s) is numlist (%s)", $2, prnumlist($4));
		info(INFO_PARSE, "cfparse: input %s is %s", $2, prnumlist($4));
		(void) install($2, ST_NL_INPUT, (char *) $4);
	};

disconnect:
	CF_DISCONNECT chan CF_FROM chan CF_SEMI {
		debug(DB_PARSE, "cfparse: disconnect: disconnect chan (%s) from chan (%s)", prnumlist($2), prnumlist($4));
		info(INFO_PARSE, "cfparse: disconnect %s from %s", prnumlist($2), prnumlist($4));
		if (($2 != NULL) && ($4 != NULL))
			(void) (*sw->sw_disconn)($2, $4);

		if ($2 != NULL)
			freenl($2);
		if ($4 != NULL)
			freenl($4);
	} |
	CF_DISCONNECT chan CF_SEMI {
		debug(DB_PARSE, "cfparse: disconnect: disconnect chan (%s)", prnumlist($2));
		info(INFO_PARSE, "cfparse: disconnect %s", prnumlist($2));
		if ($2 != NULL) {
			(void) (*sw->sw_disconn)($2, NULL);
			freenl($2);
		}
	};

connect:
	CF_CONNECT chan CF_TO chan CF_SEMI {
		debug(DB_PARSE, "cfparse: connect: connect chan (%s) to chan (%s)", prnumlist($2), prnumlist($4));
		info(INFO_PARSE, "cfparse: connect %s to %s", prnumlist($2), prnumlist($4));
		if (($2 != NULL) && ($4 != NULL))
			(void) (*sw->sw_conn)($2, $4);

		if ($2 != NULL)
			freenl($2);
		if ($4 != NULL)
			freenl($4);
	};

init:
	CF_INIT CF_SEMI {
		info(INFO_PARSE, "cfparse: init");
		client.cl_err = ASW_ERR_INIT;
		/* (void) reconf(); */
	};

dump:
	CF_DUMP CF_SEMI {
		extern char	*prconnlist();
		static char	*connlist;

		info(INFO_PARSE, "cfparse: dump");
		if (strlen(connlist = prconnlist()))
			err(ERR_PARSE, "cfparse: dump: %s", connlist);
		else
			err(ERR_PARSE, "cfparse: dump: empty connlist");
	};

reset:
	CF_RESET CF_SEMI {
		info(INFO_PARSE, "cfparse: reset");
		(void) (*sw->sw_reset)();
	};

chan:
	type ident {
		struct hlist *hl;

		debug(DB_PARSE, "cfparse: chan: ident (%s)", $2);
		if ((hl = lookup($2, $1)) == NULL) {
			err(ERR_PARSE, "cfparse: chan: can't find symbolic chan %s", $2);
			client.cl_err = ASW_ERR_SYMCHAN;
			$$ = NULL;
		}
		else {
# ifdef notdef
			/*
			 * shouldn't be necessary since
			 * the type was set already by
			 * the input/output command.
			 */
			if ($1 == ST_NL_INPUT)
				typenl(hl->hl_numlist, NL_INPUT);
			else if ($1 == ST_NL_OUTPUT)
				typenl(hl->hl_numlist, NL_OUTPUT);
			else
				typenl(hl->hl_numlist, -1); /* can't happen */
# endif notdef

			$$ = savenl(hl->hl_numlist);
		}
	} |
	type ident CF_LBRACK numlist CF_RBRACK {
		struct numlist *nl;
		struct hlist *hl;

		debug(DB_PARSE, "cfparse: ident (%s) [ numlist (%s) ]", $2, prnumlist($4));
		if ((hl = lookup($2, $1)) == NULL) {
			err(ERR_PARSE, "cfparse: chan: can't find ident %s", $1);
			client.cl_err = ASW_ERR_CHAN;
			$$ = NULL;
		}
		else if ((nl = subnl(hl->hl_numlist, $4)) == NULL) {
			err(ERR_PARSE, "cfparse: chan: can't get sublist", $1);
			client.cl_err = ASW_ERR_SUBL;
			$$ = NULL;
		}
		else {
# ifdef notdef
			/*
			 * shouldn't be necessary since
			 * the type was set already by
			 * the input/output command.
			 */
			if ($1 == ST_NL_INPUT)
				typenl(nl, NL_INPUT);
			else if ($1 == ST_NL_OUTPUT)
				typenl(nl, NL_OUTPUT);
			else
				typenl(nl, -1);	/* can't happen */
# endif notdef

			$$ = nl;	/* will get freenl'd later */
		}

		freenl($4);
	} |
	type numlist {
		debug(DB_PARSE, "cfparse: numlist (%s)", prnumlist($2));

		/*
		 * have to set the type because it isn't
		 * known since this is just a naked number
		 * list.
		 */
		if ($1 == ST_NL_INPUT)
			typenl($2, NL_INPUT);
		else if ($1 == ST_NL_OUTPUT)
			typenl($2, NL_OUTPUT);
		else
			typenl($2, -1);	/* can't happen */

		$$ = $2;	/* will get freenl'd later */
	};

type:
	CF_INPUT {
		debug(DB_PARSE, "cfparse: type: input");
		$$ = ST_NL_INPUT;
	} |
	CF_OUTPUT {
		debug(DB_PARSE, "cfparse: type: output");
		$$ = ST_NL_OUTPUT;
	};

numlist:
	num {
		debug(DB_PARSE, "cfparse: numlist: num (%d)", $1);
		$$ = maknl($1, -1);	/* don't know type so use -1 for now */
	} |
	numlist CF_COMMA num {
		debug(DB_PARSE, "cfparse: numlist: numlist (%s), num (%d)", prnumlist($1), $3);
		/* addnl appends $3 onto $1 then returns $1 */
		$$ = addnl($1, $3);
	};

num:
	CF_NUMBER {
		debug(DB_PARSE, "cfparse: num: %d", cfnum);
		$$ = cfnum;
	};

ident:
	CF_IDENT {
		debug(DB_PARSE, "cfparse: ident: %s", cfstr);
		strcpy($$, cfstr);
	};

string:
	CF_STRING {
		debug(DB_PARSE, "cfparse: string: %s", cfstr);
		strcpy($$, cfstr);
	};
