include(/usr/`include'/carl/config.m4)dnl

PROG =		aswd

DESTDIR =	m4LIBDIR
CFLAGS =	-O -I../../../`include'
LIBS =

#
# macro-mania
#
# a lot of verbosity here but the intent is to be able to print
# the correct files with "make print" (YLFILES vs. YLCFILES) and
# to be able to easily figure out what to change to add more .c
# files.
#
PRFILES =	Makefile ${HFILES} ${SRC} ${SS_CFILES} ${YLFILES}
HFILES =	aswdaemon.h client.h ident.h numlist.h symtab.h \
		connlist.h
DBCFILES =
DBOFILES =
YLFILES =	parse.y lex.l
YLCFILES =	parse.c lex.c
YLOFILES =	parse.o lex.o
SS_CFILES =	ss_conn.c ss_disconn.c ss_reset.c ss_init.c
SS_OFILES =	ss_conn.o ss_disconn.o ss_reset.o ss_init.o
SRC =		${PROG}.c data.c aswsock.c clconn.c clreq.c \
		log.c sigs.c setup.c conf.c die.c connlist.c clerr.c \
		numlist.c symtab.c switch.c
OBJ =		${PROG}.o data.o aswsock.o clconn.o clreq.o \
		log.o sigs.o setup.o conf.o die.o connlist.o clerr.o \
		numlist.o symtab.o switch.o
CFILES =	${SRC} ${YLCFILES} ${SS_CFILES}
OFILES =	${OBJ} ${YLOFILES} ${SS_OFILES} ${DBOFILES}

${PROG}:	${OFILES}
		${CC} ${OFILES} ${LIBS} -o ${PROG}
		size ${PROG}

install:	${PROG}
		install ${PROG} ${DESTDIR}

clean:
		rm -f ${PROG} lex.c parse.c parse.h *.o errs parser

tags:		${CFILES}
		ctags ${CFILES}

parse.c:	parse.y
		yacc -d parse.y
		sed \
			-e 's/yy/asw_yy/g' \
			-e 's/YY/ASW_YY/g' \
			y.tab.c > parse.c
		rm -f y.tab.c parse.h
		mv y.tab.h parse.h

lex.c:	lex.l
		lex lex.l
		sed \
			-e 's/yy/asw_yy/g' \
			-e 's/YY/ASW_YY/g' \
			lex.yy.c > lex.c
		rm -f lex.yy.c

parse.h:	parse.c

print:		${PRFILES}
		lpr -Pwlp -p ${PRFILES}

lint:		${CFILES}
		lint -hac ${CFLAGS} ${CFILES}

depend:		${CFILES}
		egrep '(^#include|^# include)' ${CFILES} | \
		egrep -v '(<|stdio\.h)' | \
		sed -e 's/:[^"]*"\([^"]*\)".*/: \1/' \
		    -e 's/\.c/.o/' \
		    -e 's,../[a-zA-Z]*/,,' | \
		awk ' { \
				if ($$1 != prev) { \
					print rec; \
					rec = $$0; \
					prev = $$1; \
				} \
				else { \
					if (length(rec $$2) > 78) { \
						print rec; \
						rec = $$0; \
					} \
					else \
						rec = rec " " $$2 \
				} \
			} \
			END { print rec } ' > Makedep
		echo '$$r Makedep' >> eddep
		echo '/^# DO NOT DELETE THIS LINE/+1,$$d' > eddep
		echo '$$r Makedep' >> eddep
		echo 'w' >> eddep
		cp Makefile.m4 Makefile.m4.bak
		ed - Makefile.m4 < eddep
		rm eddep Makedep
		@echo "don't forget to run mm"

# DO NOT DELETE THIS LINE -- make depend uses it

aswd.o: aswdaemon.h client.h
data.o: client.h clerr.h aswdaemon.h
aswsock.o: switch.h aswdaemon.h
clconn.o: client.h aswdaemon.h
clreq.o: client.h clerr.h aswdaemon.h
log.o: aswdaemon.h
sigs.o: client.h aswdaemon.h
setup.o: switch.h aswdaemon.h
conf.o: var.h symtab.h aswdaemon.h
die.o: client.h aswdaemon.h
connlist.o: connlist.h aswdaemon.h
clerr.o: aswdaemon.h client.h clerr.h
numlist.o: aswdaemon.h numlist.h
symtab.o: aswdaemon.h symtab.h numlist.h ident.h var.h
switch.o: switch.h aswdaemon.h
parse.o: aswdaemon.h switch.h numlist.h symtab.h client.h clerr.h
lex.o: parse.h symtab.h ident.h aswdaemon.h
ss_conn.o: connlist.h numlist.h ss_defs.h client.h clerr.h switch.h aswdaemon.h
ss_disconn.o: connlist.h numlist.h ss_defs.h client.h clerr.h switch.h
ss_disconn.o: aswdaemon.h
ss_reset.o: client.h clerr.h ss_defs.h switch.h aswdaemon.h
ss_init.o: ss_defs.h switch.h connlist.h aswdaemon.h
