h53929
s 00002/00004/00051
d D 1.3 86/09/12 15:57:44 dgl 3 2
c getheader does not return anything.
e
s 00000/00000/00055
d D 1.2 85/11/26 23:00:41 dgl 2 1
c eliminated LOOKED_ALREADY from getheader to cure bug 
c re. trying to add property to stdin if no header exists yet.
e
s 00055/00000/00000
d D 1.1 85/11/25 09:56:43 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>

/*
 * fgetfbuf - get buffer of floatsams
 * takes:
 * 	fp - pointer to a buffer of floats
 *	n - number of floats
 * 	iop - file descriptor
 * returns:
 * 	count of floats read
 * 	-1 on errors
 * 	0 if out of input
 * side effects:
 * 	sets up buffer for samples
 * 	if a header is present, it is read in and stored on the
 * 		property list associated with this iop
 */

fgetfbuf(fp, n, iop)
	register float *fp;
	register int n;
	FILE *iop;
{
	register struct fltbuf *fbp;
	register int i;

	fbp = &fb[fileno(iop)];			/* get fid buffer pointer */
	if (fbp->gpflt == 0) {			/* first time? */
		set_sample_size(sizeof(float));
		if (finitbuf(iop))	/* setup buffer */
			return(-1);
D 3
		if (!fbp->prop) {		/* go get header */
			if (getheader(iop) < 0)
				return(-1);
		}
E 3
I 3
		if (!fbp->prop) 		/* go get header */
			getheader(iop);
E 3
	}

	for (i = 0; i < n; i++) {
		if (fbp->pos >= fbp->n) {
			if ((fbp->n = read(fileno(iop), 
				(char *)fbp->fbuf,P_BUFSIZE))<=0)
					return(fbp->n < 0 ? fbp->n : i);
			fbp->pos = 0;
			fbp->n /= fbp->ssize;
		}
		*fp++ = fbp->fbuf[fbp->pos++];
	}

	return(n);		/* success */
}
E 1
