/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/types.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

# define UCH(ch)	((unsigned char) ch)

static char		mpu[] = "/dev/mpu0";

u_char		cmds[BUFSIZ];

setup_cmds(val)
	u_char val;
{
	static int cnt;

	cmds[cnt++] = val;
	return(cnt);
}

int bug;
char *curfile;
u_char		buf[5000];

main(argc, argv) 
	char **argv;
{
	extern u_char	ck_sum();
	int		mpu_fd;
	int		setup_len = 0;
	u_char		run_mode = MPU_SEND_SYSTEM_MESSAGE;
	int		ich, ch, channel = 0;
	u_char		uch;
	register int	len;
	FILE 		*fid;
	int 		nfds;
	int		hit = 0;

	setup_cmds(UCH(0xff));	/* reset 		*/

	while ((ch = crack(argc, argv, "hc|", 0)) != '\0') {
		switch (ch) {
			case 'c':
				channel = atol(arg_option);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if (isatty(1)) {
		if ((mpu_fd = open(mpu, 2)) == -1) {
			fprintf(stderr, "open: ");
			perror(mpu);
			exit(1);
		}
	} else
		mpu_fd = fileno(stdout);
	setup_len = setup_cmds(run_mode);	/* start stuffing */
	if (arg_index == argc)
		usage(1);

	for (nfds = 0; nfds < argc - arg_index; nfds++) {
		curfile = argv[nfds + arg_index];
		if (fid = fopen(curfile, "r")) {
			while ((len = getvoice(buf, fid)) > 0) {
				if (mpu_fd != fileno(stdout)) {
					if (write(mpu_fd, cmds, setup_len) != setup_len) {
						fprintf(stderr, "write: ");
						perror(mpu);
						exit(1);
					}
				}
				buf[2] = (buf[2] & 0x70) | (channel++ & 0xf);
				if (write(mpu_fd, buf, len) != len) {
					fprintf(stderr, "write: ");
					perror(mpu);
					exit(1);
				}
				hit++;
			} 
		} else {
			fprintf(stderr, "fopen: ");
			perror(argv[nfds + arg_index]);
			continue;
		}
		fclose(fid);
	}

	close(mpu_fd);
	if (hit)
		exit(0);
	else {
		fprintf(stderr, "mpuvload: no voices\n");
		exit(1);
	}
}

usage(ex)
{
fprintf(stderr,
"usage: mpuvload [-c] mpu_data_file ...\n\
flag:\n\
	-cN	assign first voice to channel N\n\
");
exit(ex);
}
