h39537
s 00000/00001/00106
d D 1.2 85/05/24 10:15:09 dgl 2 1
c doesn't need defaults.h, so removed it.
e
s 00107/00000/00000
d D 1.1 84/12/21 11:42:50 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/carl.h>
D 2
#include <carl/defaults.h>
E 2
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/mpu.h>
#include <math.h>

main(argc, argv)
	char **argv;
{
	extern char *	malloc();
	struct mpu_cmd *mp;			/* pointer to mpu command */
	int 		ch, 			/* for crack() */
			mi, 			/* mpc index */
			interlock = 0;		/* flag sequence control */
	u_char 		mpc[MIDI_MAX_CHANS];	/* channel function */

	if (isatty(0) || isatty(1))
		usage(1);

	/* initialize identity function */
	for (mi = 0; mi < MIDI_MAX_CHANS; mi++)
		mpc[mi] = mi;

	while ((ch = crack(argc, argv, "s|d|h", 1)) != '\0') {
		switch(ch) {
			case 's':
				mi = atoi(arg_option);
				if (mi < 0 || mi >= MIDI_MAX_CHANS)
					rangerr(mi);
				interlock = 1;
				break;
			case 'd':
				if (!interlock)
					flagerr();
				else
					interlock = 0;
				mpc[mi] = atoi(arg_option);
				if (mpc[mi] < 0 || 
				    mpc[mi] >= MIDI_MAX_CHANS)
					rangerr(mpc[mi]);
				break;
			case 'h':
				usage(0);
			default:
				usage(0);
		}
	}

	if ((mp = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL) {
		perror("malloc");
		exit(1);
	}

	/* get an mpu command */
	while ((mp = get_mpu_cmd(stdin, mp)) != NULL) {
		if (! mp->cmd_cont) {	/* it has a status part? */
			register u_char chan = mp->cmd_type & M_CHAN_MASK;
			register u_char cmd = mp->cmd_type & M_CMD_MASK;

			switch (cmd) {	/* only target channel commands */
				case CH_KEY_OFF:
				case CH_KEY_ON:
				case CH_CTL:
				case CH_PRG:
				case CH_P_BEND:
					mp->mpu_cmd[0] = cmd | mpc[chan];
					break;
				default:
					break;
			}
		}
		put_mpu_cmd(stdout, mp);
	}

	exit(0);
}

flagerr()
{
	fprintf(stderr, "mpupatch: flags out of order\n");
	usage(3);
}

rangerr(r)
{
	fprintf(stderr, "%s%d%s%d",
		"mpupatch: channel out of range =",
		r,
		"limit is ",
		MIDI_MAX_CHANS);
	usage(2);
}

usage(ex)
{
	fprintf(stderr,  "%s%s%s%s%s",
		"usage: mpupatch [-sN -dN]... < mpu_data > mpu_data\n",
		"flags:\n",
		"\t-sN\tset source to channel N\n",
		"\t-dN\tset destination to channel N\n",
		"\tNote: the flags must appear in the order shown\n");
	exit(ex);
}
E 1
