#include <stdio.h>
#include <carl/carl.h>
#include <carl/defaults.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/mpu.h>
#include <math.h>

float   timefac = MPU_DEFAULT_TEMPO,
	tb = MPU_DEFAULT_TIME_BASE;

main(argc, argv)
	char **argv;
{
	extern char *malloc();
	struct mpu_cmd *mpx, *mpy;
	FILE *f1, *f2;
	int	otty = isatty(1);
	int	ch;
	float	tx = 0, ty = 0;
	char	px, py;
	char	norm = 0;

	while ((ch = crack(argc, argv, "t|B|", 1)) != '\0') {
		switch(ch) {
			case 'B':
				tb = sfexpr(arg_option, 1.0);
				break;
			case 't':	/* set tempo */
				timefac = sfexpr(arg_option, 1.0);
				break;
		}
	}
	timefac = 1.0 / MPU_TPS(timefac, tb);
	arg_index = 0;
	while ((ch = crack(argc, argv, "nh", 0)) != '\0') {
		switch (ch) {
			case 'n':
				norm++;
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}
	if (argc - arg_index < 2)
		usage(1);

	if ((mpx = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL){
		perror("malloc");
		exit(1);
	}
	if ((mpy = (struct mpu_cmd *) malloc(sizeof(struct mpu_cmd))) == NULL){
		perror("malloc");
		exit(1);
	}

	if ((f1 = fopen(argv[arg_index], "r")) == NULL) {
		perror("fopen");
		exit(1);
	}
	if ((f2 = fopen(argv[arg_index+1], "r")) == NULL) {
		perror("fopen");
		exit(1);
	}

	for (;;) {
		while ((mpx = get_mpu_cmd(f1, mpx)) != NULL) {
			if (mpx->mpu_cmd[0] == CH_KEY_ON
			    && mpx->mpu_cmd[2] != 0) {
				tx += mpx->time_tag;
				px = mpx->mpu_cmd[1];
				savex(tx, px);
				break;
			}
		}
		if (mpx == NULL)
			break;
		while ((mpy = get_mpu_cmd(f2, mpy)) != NULL) {
			if (mpy->mpu_cmd[0] == CH_KEY_ON
			    && mpy->mpu_cmd[2] != 0) {
				ty += mpy->time_tag;
				py = mpy->mpu_cmd[1];
				savey(ty, py);
				break;
			}
		}
		if (mpy == NULL)
			break;
		if (!norm)
		    if (otty)
			    printf("%f\t%f\t%s\t%s\n", tx * timefac, 
				ty * timefac, pk(px), pk(py));
		    else
			    printf("%f\t%f\t%s\n", tx * timefac, 
				ty * timefac, pk(px));
	}
	if (norm) {
		normalize();
		pnorm();
	}
	exit(0);
}

usage(ex)
{
	fprintf(stderr, "usage: mpucmp [flags] data_x data_y > text_pairs\n");
	exit(ex);
}

static float txbuf[BUFSIZ];
static char pxbuf[BUFSIZ];
static long txcnt;
static float tybuf[BUFSIZ];
static char pybuf[BUFSIZ];
static long tycnt;

savex(x, p)
	float x;
	char p;
{
	txbuf[txcnt] = x;
	pxbuf[txcnt] = p;
	txcnt++;

}

savey(y, p)
	float y;
	char p;
{
	tybuf[tycnt] = y;
	pybuf[tycnt] = p;
	tycnt++;

}


normalize()
{
	register int	i;
	register float	ratio = txbuf[txcnt-1] / tybuf[tycnt-1]; 

	for (i = 0; i < tycnt; i++)
		tybuf[i] = tybuf[i] * ratio;
}

pnorm()
{
	register int i;

	for (i = 0; i < txcnt; i++)
		printf("%f\t%f\t%s\n", txbuf[i] * timefac, tybuf[i] * timefac, 
			pk(pxbuf[i]));
		
}
