# include <stdio.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>

char	mpu[] = "/dev/mpu0";

# define MPU_TRACK(x) (1 << x)

u_char	cmds[] = {
	0xff,		/* reset */
	0xec,		/* active track */
	MPU_TRACK(0),	/* track 0 */
	0xb8 		/* clear play */
}

main() 
{
	u_char	buf[BUFSIZ];
	int	fd, track, n;

	/* open for reading and writing */
	if ((fd = open(mpu, 2)) == -1)
		exit(2);

	/* tell the driver where to send data */
	track = MPU_TR_COM;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(3);


	/* tell the driver where to send data */
	track = 0;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);

	while ((n = read(0, buf, BUFSIZ)) > 0)
		if (write(fd, buf, n) != n)
			exit(5);

	/* tell the driver where to send data */
	track = MPU_TR_COM;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(6);

	mpu_write(fd, 0x0a);	/* start play */
	close(fd);
}
