/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>

/*
 * midi_pk -	key to pitch converter for midi
 * takes:
 * 	key -	midi key index
 * returns:
 * 	static string containing corresponding pitch
 */

char *
midi_pk(key)
	u_char key;
/*
 * Return string name of 'key' and octave number
 * (e.g., 'midi_pk(61)' is 'C#4', middle C sharp).
 */
{
	static char *pcs[] = {"C", "C#", "D", "D#", "E", "F", "F#", "G",
		"G#", "A", "A#", "B"};
	static char rtn[8];
	int pc = key % 12;
	int oct = key / 12 - 1;

	sprintf(rtn, "%s%d", pcs[pc], oct);
	return(rtn);
}
