/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/time.h>
# include <sys/types.h>


/*
 * iwait -	wait to read on fd until it is ready, or timeout
 * takes:
 * 	fd -		unix file descriptor
 * 	time -		time in seconds for timeout
 * returns:
 * 	!= 0 when fid is readable, 0 if timeout, -1 on errors
 */

iwait(fd, time)
	int fd; 
	u_long time;
{
	struct timeval timeout;
	int readfd = 1 << fd;

	timeout.tv_sec = time;
	timeout.tv_usec = 0;
	return(select(sizeof(int)*8,  &readfd, (int *)0, (int *)0, &timeout));
}
