/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sgtty.h>

/*
 * setcbrk -	set cbreak mode on fd
 * clrbrk -	clear cbreak mode on fd
 */

static struct sgttyb tty;

setcbrk(fd)
	int fd;
{
	if (gtty(fd, &tty) < 0) {
		perror("gtty");
		return;
	}
	tty.sg_flags |= CBREAK; 
	if (stty(fd, &tty) < 0) 
		perror("stty");
}

clrcbrk(fd)
	int fd;
{
	if (gtty(fd, &tty) < 0) {
		perror("gtty");
		return;
	}
	tty.sg_flags &= ~CBREAK;
	if (stty(fd, &tty) < 0)
		perror("stty");
}


/*
 * main()
 * {
 * 	int i, c;
 * 	setcbi();
 * 	for (i = 0; i < 10; i++) {
 * 		if ((c = getchar()) == EOF)
 * 			break;
 * 	}
 * 	clrcbi();
 * 
 * }
 */
