#include <stdio.h>
#include <carl/libcarlmidi.h>

TransposeMpuCmd(m, shift)
	MpuCmd *m;
	int shift;
/*
** Transpose the 'MpuCmd' 'm' by 'shift' half steps
** (e.g., if 'shift' is '-7', 'm' is transposed down a fifth.
*/
{
	if (IsNote(m)) MpuPitch(m) += (unsigned char) shift;
}

MidiTranspose(in,out,shift)
	FILE *in, *out;
/*
** Copy the midi data from 'in' and transpose it by 'shift' half steps,
** writing the result in 'out'.
** Example: 'MidiTranspose(in,out,-7)' transposes down a fifth.
*/
{
	MpuCmd m;
	while (GetMpuCmd(in,&m)) {
		TransposeMpuCmd(&m,shift);
		PutMpuCmd(out,&m);
	}
}
