/* da_dx7_sx.c	1.2	(CARL)	5/31/85	16:15:42 */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * da_dx7_sx - disassemble dx7 system exclusive midi data
 * takes:
 * 	fid -	output file descriptor for disassembly
 * 	ch -	pointer to char array of system exclusive code
 * side effects:
 * 	returns -1 on the following format errors:
 * 		not dx7 code
 * 		no such format
 * 		no such param
 * 		no such group
 * 		no such sub status
 * notes:
 * 	this routine is used by mpuda(1carl).
 */

#define range(x, base, len) (x >= base && x < base + len)

da_dx7_sx(fid, ch)
	FILE *fid;
	u_char *	ch;
{
	register int i, j, k, opct;
	u_short sub_status, channel, format, byte_count,
		group, param, data, index;
	int 	check_sum = 0; 

	if (ch[1] != ID_DX7) {
		fprintf(fid, "da_dx7_sx: not dx7 code!\n");
		return(-1);
	}

	sub_status	= (ch[2] >> 4) & 07;
	channel		= ch[2] & 0xF;
	format = ch[3];
	byte_count = ch[4] << 7 | ch[5];

	switch (sub_status) {
		case SX_DX7_AS:
			fprintf(fid, "sxas;\tsys. ex. dx7 active sensing\n");
			return(0);
		case SX_DX7_BD:
			switch (format) {
			    case SX_DX7_1V: 
				fprintf(fid, "%s\n",
				    "sxbd1v;\tsys. ex. dx7 one voice");
		 		fprintf(fid, "%2x\t; mfg. id.    =\t%d\n",
					ch[1], ch[1]);
		 		fprintf(fid, "%2x\t; sub-status  =\t%d\n",
					ch[2], sub_status);
		 		fprintf(fid, "\t; channel     =\t%d\n",
					channel);
		 		fprintf(fid, "%2x\t; format      =\t%d\n",
					format, format);
		 		fprintf(fid, "%2x\t; byte count  =\t%d\n",
					ch[4], byte_count);
		 		fprintf(fid, "%2x\t;\n", ch[5]);
				sx_dx7_1v(fid, ch);
				break;
			    case SX_DX7_32V:
				fprintf(fid, "%s %s\n",
				    "sxbd32v;\tsys. ex. dx7", "32 voices");
		 		fprintf(fid, "%2x\t; mfg. id.    =\t%d\n",
					ch[1], ch[1]);
		 		fprintf(fid, "%2x\t; sub-status  =\t%d\n",
					ch[2], sub_status);
		 		fprintf(fid, "\t; channel     =\t%d\n",
					channel);
		 		fprintf(fid, "%2x\t; format      =\t%d\n",
					format, format);
		 		fprintf(fid, "%2x\t; byte count  =\t%d\n",
					ch[4], byte_count);
		 		fprintf(fid, "%2x\t;\n", ch[5]);
				sx_dx7_32v(fid, ch);
				break;
			    default:
				fprintf(fid, "%s = %d\n",
					"da_dx7_sx: no such format", 
					format);
				    return(-1);
			}
			break;
		case SX_DX7_PC:
			group 	= ch[3] >> 2 & 0x1F;
			param	= ((ch[3] & 3) << 7) | ch[4];
			data	= ch[5];
			/* 
			 * note, apparent error in dx7 midi format spec.
			 * which claims that Parameter Number is a 16-bit
			 * quantity, when it appears in reality to be only
			 * 9-bits.
			 */
			switch (group) {
				case SX_DX7_GRP_VPAR:
				    j = DX7_INI_IND(param % DX7NVOX);
				    fprintf(fid, "%-8d%-8d%-8d%-8d%s\n",
					    param,
					    j,
					    data,
					    dx7_ini_vox[j].par_ub,
					    dx7_ini_vox[j].par_name);
				    break;
				case SX_DX7_GRP_FPAR:
				    for (i = 0; i < dx7_ini_fun_len; i++)
					if (param == dx7_ini_fun[i].par_index)
						break;
				    if (i < dx7_ini_fun_len)
					fprintf(fid, "%-10d%-10d%s\n", 
						data,
						dx7_ini_fun[i].par_ub,
						dx7_ini_fun[i].par_name);
				    else {
					fprintf(fid, "%s = %d\n",
						"da_dx7_sx: no such param.", 
						param);
					return(-1);
				    }
				    break;
				default:
				    fprintf(fid, "%s = %d\n",
					    "da_dx7_sx: no such group", group);
				    return(-1);
			}
			break;
		default:
			fprintf(fid, "%s = %d\n",
				"da_dx7_sx: no such sub status", sub_status);
			return(-1);
	}
	return(0);
}
