h44779
s 00058/00000/00000
d D 1.1 84/12/21 11:06:23 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * da_dx7_voice(dx, v, ofid)	- disassemble dx7 voice structure
 * 	struct dx7 dx;		- state structure to disassemble
 * 	int v;			- voice within structure 
 * 	FILE *ofid;		- ofid file descriptor for output
 * returns:
 * 	nothing
 * side effects:
 * 	prints disassembly on ofid
 * notes:
 * 	For each voice parameter, it prints its index, value, range
 * 	and parameter name.
 * 	
 */

da_dx7_voice(dx, v, ofid)
	register struct dx7 dx;
	register int v;
	FILE *ofid;
{
	register int i, j;
	char buf[VOX_NAME_LEN + 1];

	/* print header line *;
	fprintf(ofid, "%-10s%-10s%-10s%-10s\n", 
		"index", "value", "range", "name");

	/* print operator values */
	for (i = 0; i < VOX_NAME_BASE; i++) {
		j = DX7_INI_IND(i);
		fprintf(ofid, "%-10d%-10d%-10d%s\n",
			i,
			dx.dx7_vox_val[v][i],
			dx7_ini_vox[j].par_ub,
			dx7_ini_vox[j].par_name);
	}

	/* print voice name */
	DX7_GET_VNAME(dx, buf, v);
	fprintf(ofid, "%-10d%-20s%s\n",
		VOX_NAME_BASE,
		buf,
		dx7_ini_vox[DX7_INI_IND(vox_voice_name)].par_name);

	/* print operator enable */
	fprintf(ofid, "%-9d0%-9o0%-10o%s\n",
		vox_op_ena,
		dx.dx7_vox_val[v][vox_op_ena],
		dx7_ini_vox[DX7_INI_IND(vox_op_ena)].par_ub,
		dx7_ini_vox[DX7_INI_IND(vox_op_ena)].par_name);
}
E 1
