h46858
s 00030/00061/00108
d D 1.2 85/05/31 16:15:42 dgl 2 1
c improved formatting of system exclusive command.
e
s 00169/00000/00000
d D 1.1 84/12/21 11:06:13 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * da_dx7_sx - disassemble dx7 system exclusive midi data
 * takes:
 * 	fid -	output file descriptor for disassembly
 * 	ch -	pointer to char array of system exclusive code
 * side effects:
 * 	returns -1 on the following format errors:
 * 		not dx7 code
 * 		no such format
 * 		no such param
 * 		no such group
 * 		no such sub status
 * notes:
 * 	this routine is used by mpuda(1carl).
 */

#define range(x, base, len) (x >= base && x < base + len)

da_dx7_sx(fid, ch)
	FILE *fid;
	u_char *	ch;
{
	register int i, j, k, opct;
	u_short sub_status, channel, format, byte_count,
		group, param, data, index;
	int 	check_sum = 0; 
I 2

E 2
	if (ch[1] != ID_DX7) {
		fprintf(fid, "da_dx7_sx: not dx7 code!\n");
		return(-1);
	}

	sub_status	= (ch[2] >> 4) & 07;
	channel		= ch[2] & 0xF;
I 2
	format = ch[3];
	byte_count = ch[4] << 7 | ch[5];
E 2

	switch (sub_status) {
		case SX_DX7_AS:
			fprintf(fid, "sxas;\tsys. ex. dx7 active sensing\n");
			return(0);
		case SX_DX7_BD:
D 2
			format = ch[3];
			byte_count = ch[4] << 8 | ch[5];
E 2
			switch (format) {
D 2
			    register u_char val;
E 2
			    case SX_DX7_1V: 
				fprintf(fid, "%s\n",
D 2
				    "sxbd1v;\tsys. ex. dx7 data, one voice");
				for (opct = 5, i = 0; i < DX7VOXLEN; i++) {
				    j = DX7_INI_IND(i);
				    val = ch[i + 6];
				    fprintf(fid, 
					(range(i, VOX_NAME_BASE, VOX_NAME_LEN))
					 ? "%2x\t; vox    [%3d]=\t%-10c%-10d%s"
					 : "%2x\t; vox    [%3d]=\t%-10d%-10d%s",
					    val,
					    i,
					    val,
					    dx7_ini_vox[j].par_ub,
					    dx7_ini_vox[j].par_name);
				    if (j == 0)
					    fprintf(fid, "\top[%d]\n", opct--);
				    else
					    fprintf(fid, "\n");
				    check_sum += val;
				}
				val = ch[DX7VOXLEN + 6];
				fprintf(fid, "%2x\t; check-sum=\t%d", val, val);
				check_sum = 0x80 - (0x7f & check_sum);
				if (val == check_sum)
				    fprintf(fid, "\t\tvalid check-sum\n");
				else
				    fprintf(fid, "\t\t%s %x != %x\n",
					"invalid check-sum",
					val,
					check_sum);
E 2
I 2
				    "sxbd1v;\tsys. ex. dx7 one voice");
		 		fprintf(fid, "%2x\t; mfg. id.    =\t%d\n",
					ch[1], ch[1]);
		 		fprintf(fid, "%2x\t; sub-status  =\t%d\n",
					ch[2], sub_status);
		 		fprintf(fid, "\t; channel     =\t%d\n",
					channel);
		 		fprintf(fid, "%2x\t; format      =\t%d\n",
					format, format);
		 		fprintf(fid, "%2x\t; byte count  =\t%d\n",
					ch[4], byte_count);
		 		fprintf(fid, "%2x\t;\n", ch[5]);
				sx_dx7_1v(fid, ch);
E 2
				break;
			    case SX_DX7_32V:
				fprintf(fid, "%s %s\n",
D 2
				    "sxbd32v;\tsystem exclusive dx7",
				    "bulk data for 32 voices");
				for (k = 0; k < DX7NVOX; k++) {
				    for (i = 0; i < DX7VOXLEN; i++) {
					j = DX7_INI_IND(i);
					val = ch[i * k + 6];
					fprintf(fid, 
					    (range(i, VOX_NAME_BASE, VOX_NAME_LEN))
					     ? "%2x\t; vox    [%3d]=\t%-10c;%-10d%s"
					     : "%2x\t; vox    [%3d]=\t%-10d;%-10d%s",
						val,
						i,
						val,
						dx7_ini_vox[j].par_ub,
						dx7_ini_vox[j].par_name);
					check_sum += val;
				    }
				}
				val = ch[DX7COMLEN + 6];
				fprintf(fid, "%2x\t; check-sum=%d", val, val);
				check_sum = 0x80 - (0x7f & check_sum);
				if (val == check_sum)
				    fprintf(fid, "\tvalid check-sum\n");
				else
				    fprintf(fid, "\t%s %x != %x\n",
					"invalid check-sum",
					val,
					check_sum);
E 2
I 2
				    "sxbd32v;\tsys. ex. dx7", "32 voices");
		 		fprintf(fid, "%2x\t; mfg. id.    =\t%d\n",
					ch[1], ch[1]);
		 		fprintf(fid, "%2x\t; sub-status  =\t%d\n",
					ch[2], sub_status);
		 		fprintf(fid, "\t; channel     =\t%d\n",
					channel);
		 		fprintf(fid, "%2x\t; format      =\t%d\n",
					format, format);
		 		fprintf(fid, "%2x\t; byte count  =\t%d\n",
					ch[4], byte_count);
		 		fprintf(fid, "%2x\t;\n", ch[5]);
				sx_dx7_32v(fid, ch);
E 2
				break;
			    default:
D 2
				    fprintf(fid, "%s = %d\n",
E 2
I 2
				fprintf(fid, "%s = %d\n",
E 2
					"da_dx7_sx: no such format", 
					format);
				    return(-1);
			}
			break;
		case SX_DX7_PC:
			group 	= ch[3] >> 2 & 0x1F;
			param	= ((ch[3] & 3) << 7) | ch[4];
			data	= ch[5];
			/* 
			 * note, apparent error in dx7 midi format spec.
			 * which claims that Parameter Number is a 16-bit
			 * quantity, when it appears in reality to be only
			 * 9-bits.
			 */
			switch (group) {
				case SX_DX7_GRP_VPAR:
				    j = DX7_INI_IND(param % DX7NVOX);
				    fprintf(fid, "%-8d%-8d%-8d%-8d%s\n",
					    param,
					    j,
					    data,
					    dx7_ini_vox[j].par_ub,
					    dx7_ini_vox[j].par_name);
				    break;
				case SX_DX7_GRP_FPAR:
				    for (i = 0; i < dx7_ini_fun_len; i++)
					if (param == dx7_ini_fun[i].par_index)
						break;
				    if (i < dx7_ini_fun_len)
					fprintf(fid, "%-10d%-10d%s\n", 
						data,
						dx7_ini_fun[i].par_ub,
						dx7_ini_fun[i].par_name);
				    else {
					fprintf(fid, "%s = %d\n",
						"da_dx7_sx: no such param.", 
						param);
					return(-1);
				    }
				    break;
				default:
				    fprintf(fid, "%s = %d\n",
					    "da_dx7_sx: no such group", group);
				    return(-1);
			}
			break;
		default:
			fprintf(fid, "%s = %d\n",
				"da_dx7_sx: no such sub status", sub_status);
			return(-1);
	}
	return(0);
}
E 1
