h62132
s 00019/00007/00096
d D 1.2 89/01/19 22:41:21 root 2 1
c fixed to work with latest version of Player.
e
s 00103/00000/00000
d D 1.1 87/04/29 15:42:15 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>
#include <carl/mpu.h>

elapsed_time(fd)
	int fd;
{
	static	 long	elapsed_ticks;
	register long	tticks = Now * MPU_DEFAULT_TICS_PER_SEC + .5;
	register int	ticks = tticks - elapsed_ticks;
	register int	periods = ticks / MPU_CLOCK_PERIOD;
	register int	phase   = ticks % MPU_CLOCK_PERIOD;

	while(periods--)
		midi_out(fd, RT_TCIP);

	midi_out(fd, phase);
	elapsed_ticks = tticks;
}

/*
 * play_note -	emit MPU-401 code for note
 * takes:
 * 	P4 of parent as duration of note to play
 * 	P5 of parent as MIDI key index
 * 	P6 of parent as velocity of attack
 * 	P7 of parent as channel
 */

# define CRACK(flag, ac, av, flags, ign) while ((flag = crack(ac, av, flags, 1)) != NULL)

M_start()
{
	extern int arg_index;
	extern char *arg_option;
	int flag;

D 2
	CRACK(flag, argc, argv, "h", 1) {
E 2
I 2
	CRACK(flag, Argc, Argv, "h", 1) {
E 2
		switch (flag) {
			case 'h':
			default:
				usage(0);
		}
	}
D 2
	Out_proc = NULL;
E 2
I 2
	Print_notes = NULL;
E 2
	SubstitutePname("play_note");
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s",
"cmus2mpu: usage:\n",
"    cmus2mpu < cmusic_note_statements > mpu_code\n",
"where each note_statement is:\n",
"    note begin_time any_name duration key [[[velocity] channel] program];\n");
exit(ex);
}

M_ter()
{
	midi_out(1, 0);
	midi_out(1, 0xf9);
}

Player play_note()
{
	extern double timescale();
	Instance int sequence; 
D 2
	Instance u_char key, chan;
E 2
I 2
	Instance u_char key, chan, prg;
E 2
	Instance double time;
	u_char vel;

	if (sequence == 0) {
D 2
		key = atof(Pi5);
		vel = atof(Pi6);
		chan = atof(Pi7);
E 2
I 2
		key = atoi(Pi5);
		if (Hipn(Self, -1) >= 6)
			vel = atoi(Pi6);
		else
			vel = 64;
		if (Hipn(Self, -1) >= 7)
			chan = atoi(Pi7);
		else
			chan = 0;
		if (Hipn(Self, -1) >= 8) {
			prg = atoi(Pi8);
			elapsed_time(1);
			if (send_ch(1, CH_PRG, chan, prg, 0) != 0)
				Pexit(1);
		}
E 2
		elapsed_time(1);
		if (send_ch(1, CH_KEY_ON, chan, key, vel) != 0)
D 2
			exit(1);
E 2
I 2
			Pexit(1);
E 2
		Wait_until(Abs_time() + atof(Pi4));
		sequence++;
	} else {
		elapsed_time(1);
		if (send_ch(1, CH_KEY_ON, chan, key, 0) != 0)
		    exit(1);
		Kill(Self);
	}
}

/*
 * double
 * timescale(Now)
 * {
 * 	static double start = 1.0, end = .5;
 * 	static double dur = 100.0;
 * 	double f = (Now - dur) / dur;
 * 
 * 	return((f * end + ((1.0 - f) * start)) * Now);
 * }
 */
E 1
