h58464
s 00000/00002/00064
d D 1.2 85/10/24 09:57:24 dgl 2 1
c mpu_trk and mpu_trkp enhancements.
e
s 00066/00000/00000
d D 1.1 85/10/15 16:19:08 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 2
/* %M%	%I%	(CARL)	%G%	%U% */

E 2
# include <carl/sa_mpuvar.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/dx7.h>

mpu_record(mpu_unit, rbuf, rlen)
	int	mpu_unit;
	char	*rbuf;
	int	rlen;
{
	extern int	printit;
	char		ibuf[32];
	register int	i, n, len = 0, record = 0;

	mpu_set_record_mode(mpu_unit);

	while ((n = mpu_readmsg(mpu_unit, ibuf, sizeof(ibuf))) > 0) {
		/* skip until portamento foot switch is depressed */
		if (n==4 && (ibuf[1] & 0xf0) == CH_CTL 
		    && ibuf[2] == CTL_DX7_PORTA_FSW) {
			/* portamento footswitch has changed */
			if (ibuf[3] == 0x7f) {	/* switch down */
				printf("<\t");
				record = 1;
				continue;	/* skip this command */
			} else {
				printf(">%d\n", len);
				break;		/* and this one */
			}
		}
		if (record == 1) {
			for (i = 0; ((i < n) && (len < rlen)); i++) {
				if (printit == 4)
					fprintf(1, "%x ", ibuf[i] & 0xff);
				rbuf[len++] = ibuf[i];
			}
			if (printit == 4)
				fprintf(1, "\n");
		}
	}
	mpu_reset(mpu_unit);
	return(len);
}

static unsigned char recmode[] = { 
		0xff,	/* reset */
		0x33,	/* thru off */
		0x88,	/* midi thru off */
		0x87,	/* pitch bender on */
		0x26	/* start recording, stop playing */
};


mpu_set_record_mode(mpu_unit)
{
	/* set command track to turn on MPU in record mode */
	if (mpu_set_track(mpu_unit, MPU_TR_COM) != 0)
		exit(3);
	/* reset mpu, and fire it up in record mode */
	if (mpu_write(mpu_unit, recmode, sizeof(recmode)) != sizeof(recmode))
		exit(2);
}
E 1
