h03447
s 00031/00009/00107
d D 1.2 85/10/24 10:25:10 dgl 3 1
c 
e
s 00032/00010/00106
d R 1.2 85/10/24 09:57:42 dgl 2 1
c mpu_trk and mpu_trkp enhancements.
e
s 00116/00000/00000
d D 1.1 85/10/16 14:48:21 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <carl/sa_mpuvar.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include "medit.h"

typedef Player * Pptr;

extern Pptr 	P[P_TRK];
extern int	busy[P_TRK];
extern int	key;
extern struct mpu_trk mpu_trk[P_TRK];
extern int	cur_trk;
extern int	printit;

keydown()
{
	int	ch;

	if (nb_acia_read(0, &ch) != 0) {
		acia_write(0, ch);
		key = ch;
		return(TRUE);
	} else
		return(FALSE);
}

Player keytest(0)
{
I 3
	Instance int tmpvar;

E 3
	P_start {
		Wait_for(keydown, CONTINUOUS);
		Return;
	}

D 3
	acia_write(0, key);
E 3
	switch (key) {
		register int	i, j;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
D 3
			cur_trk = key - '0';
E 3
I 3
			tmpvar = key - '0';
E 3
			break;
I 3
		case 'P':
			printit = tmpvar;
			break;
E 3
		case 'R':
			mpu_reset(0);
			/* select playback track */
			if (mpu_set_track(0, MPU_TR_COM) != 0)
				exit(1);
D 3
		case 'P':
			printit = cur_trk;
			break;
E 3
		case 'S':
D 3
			Stop(P[cur_trk]);
E 3
I 3
			{
			register int	i;
			for (i = 0; i < P_TRK; i++)
				Set_p(P[i], 1L, 0L);
E 3
			break;
I 3
			}
E 3
		case '.':	/* quit */
			Pexit();
		case 'c':
			{
			register int pq;
			if ((pq = getpfree()) == -1) {
				fprintf(1, "all busy\n");
				break;
			}
I 3
			cur_trk = tmpvar;
			/* P0 ==> track number */
E 3
			Set_p(P[pq], 0L, cur_trk);
I 3
			/* P1 ==> continuous/once-only */
E 3
			Set_p(P[pq], 1L, 1);
			Start(P[pq]);
I 3
			printf("%d\n", pq);
E 3
			break;
			}
		case 'd':
D 3
			dump_trk(mpu_trk[cur_trk]);
E 3
I 3
			cur_trk = tmpvar;
			dump_trk(&mpu_trk[cur_trk]);
E 3
			break;
		case 'l':
D 3
			list_trk(mpu_trk[cur_trk]);
E 3
I 3
			cur_trk = tmpvar;
			list_trk(&mpu_trk[cur_trk]);
E 3
			break;
		case 'r':
I 3
			cur_trk = tmpvar;
E 3
			mpu_trk[cur_trk].trk_cnt =
			    mpu_record(0,
				mpu_trk[cur_trk].trk_buf,
				mpu_trk[cur_trk].trk_len);
			break;
		case 's':
			{
			register int pq;
			if ((pq = getpfree()) == -1) {
				fprintf(1, "all busy\n");
				break;
			}
I 3
			cur_trk = tmpvar;
			/* P0 ==> track number */
E 3
			Set_p(P[pq], 0L, cur_trk);
I 3
			/* P1 ==> continuous/once-only */
E 3
			Set_p(P[pq], 1L, 0);
I 3
			/* P2 ==> which slot in busy[] to use */
			Set_p(P[pq], 2L, pq);
E 3
			Start(P[pq]);
I 3
			printf("%d\n", pq);
E 3
			break;
D 3
			}
E 3
I 3
		}
		case 'x':
			cur_trk = tmpvar;
			Set_p(P[cur_trk], 1L, 0);
			break;
E 3
		default:
			acia_write(0, '?');
			break;
	}
}

getpfree()
{
	register int	pfree;

	for (pfree = 0; pfree < P_TRK; pfree++) {
		if (!busy[pfree])
			return(pfree);
	}
	return(-1);
}
E 1
