/*
 * Any number of voices may be declared.  All their names must be distinct.
 * While it is ordinary to supply both the begin and duration times of a voice,
 * this is sometimes redundant, as when a "Stop" expression exists in a
 * Notes or Rhythms statement.  Thus, the duration can be left out in these
 * circumstances.  N.B., a "Stop" expression had better appear somewhere
 * or the voice will never end!
 * 
 * Player beep starts beeping at 1.5 secs and goes until the "Stop".
 * Player blat starts blating at 2.5 secs and goes until the "Stop".
 * Thus, the two voices play a canon.
 */

Player beep(1.5)
{
	P4 = Rhythms("{4,8,8,{4}x2,1,2,2,1}x2 Stop");
	P5 = Pitches("{as b3 c df5 e f fs ff5 bs6 a8}x2");
	P2 = Now;
	Wait_until(P2 + P4);
}

Player blat(2.5)
{
	P4 = Rhythms("{4,8,8,{4}x2,1,2,2,1}x2 Stop");
	P5 = Pitches("{as b3 c df5 e f fs ff5 bs6 a8}x2");
	P2 = Now;
	Wait_until(P2 + P4);
}
