h63879
s 00002/00002/00066
d D 2.1 85/10/26 23:40:36 dgl 3 2
c changed variable names.
e
s 00001/00001/00067
d D 1.2 85/09/20 16:15:32 dgl 2 1
c exit() is now Pexit().
e
s 00068/00000/00000
d D 1.1 84/12/21 12:08:35 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/Player.h>
#include <ctype.h>

/*
 * get_clist -	get next cyclic list from file
 * takes:
 * 	fp -	file pointer
 * returns:	string form of cyclic list
 */

char *
get_clist(fp)
	register FILE *fp;
{
	register int c; 
	char *buf = NULL;

	for (;;) {
		if ((c = getc(fp)) == EOF || c == ';') {
			if (buf == NULL)		/* nothing saved? */
				break;			/* just return */
			else
				(void) strsav(&buf, '\0');/* else terminate */
			break;				/* and return */
		}
		if (buf == NULL && isspace(c))		/* kill initial */
			continue;			/* white space */
		else
			(void) strsav(&buf, c);
	}
	return(buf);
}

/* 
 * Read_lists - read all cyclic list strings from a file
 * takes:
 *	file -	file name containing cyclic list statements
 * side effects:
 *	Parses cyclic lists, installs them in ST_CYCLIST and ST_CYCLABL
 *	symbol tables.
 */

Read_lists(file)
	register char *file;
{
	register char *cnotes;
	register FILE *fp;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "Read_list_file: can't read: %s\n", file);
D 2
		exit(1);
E 2
I 2
		Pexit(1);
E 2
	}

	while ((cnotes = get_clist(fp)) != NULL) {
D 3
		extern struct noteheader *newid();
		register struct noteheader *h = newid(cnotes);
E 3
I 3
		extern struct headcl_hcl *newid();
		register struct headcl_hcl *h = newid(cnotes);
E 3

		if (buildnotes(h, cnotes) == 0) {
			/* skip over any initial branch nodes */
			nextnot(h);
		}
		free(cnotes);
	}
	(void) fclose(fp);
}
E 1
