h53683
s 00001/00051/00482
d D 2.2 86/01/30 16:36:35 dgl 8 7
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00106/00106/00427
d D 2.1 85/10/26 23:41:37 dgl 7 6
c changed variable names.
e
s 00003/00000/00530
d D 1.6 85/10/10 16:52:02 dgl 6 5
c Added ``Kill'' cyclic list directive.
e
s 00005/00005/00525
d D 1.5 85/09/20 16:14:41 dgl 5 4
c exit() is now Pexit().
e
s 00022/00013/00508
d D 1.4 85/03/13 22:56:14 dgl 4 3
c Fixed problem with ``&'' chord parsing.
e
s 00006/00013/00515
d D 1.3 85/01/11 16:46:05 dgl 3 2
c improved method of locating terminators for cyclic list fields.
e
s 00005/00001/00523
d D 1.2 85/01/10 23:24:13 dgl 2 1
c changed way Stop and Hold are scanned, and added metronome code
e
s 00524/00000/00000
d D 1.1 84/12/21 12:06:24 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>
#include "debug.h"

/*
 * pnotes -	print cyclic list, for debugging
 */

pnotes(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
D 7
	register struct notnod *x;
E 7
I 7
	register struct clist_cl *x;
E 7

	if (h == NULL)
		return(-1);
D 4
	printf("name=%s\th=%x\ttype=%d\tNnotes=%d\tnh=%x\tnp=%x\n", 
E 4
I 4
	printf(
D 7
"name=%s\th=%x\ttype=%d\tNnotes=%d\tnh=%x\tnp=%x\n", 
E 4
		h->nn, 
		h, h->type, h->Nnotes,
		h->np);
D 4
	for (x = h->nh; x != NULL; x = x->nxtnot)
E 4
I 4
	for (x = h->nh; x != NULL; x = x->nxtnot) {
E 7
I 7
"name=%s\th=%x\ttype=%d\thcl_len=%d\thcl_nh=%x\thcl_np=%x\n", 
		h->hcl_nn, 
		h, h->hcl_type, h->hcl_len,
		h->hcl_np);
	for (x = h->hcl_nh; x != NULL; x = x->cl_next) {
E 7
E 4
		printf(
D 4
"x=%x\tdatum=%s\tmeasure_id=%s\tf_bcnt=%d f_times=%d\n\tnxtnot=%x lstnot=%x f_branch=%x\n",
E 4
I 4
"x=%x\tdat=%s\tmeas=%s\tbcnt=%d times=%d\n\tnxt=%x lst=%x br=%x\n",
E 4
D 7
			 x, x->datum, x->measure_id, x->f_bcnt, x->f_times, 
			 x->nxtnot, x->lstnot, x->f_branch);
E 7
I 7
			 x, x->cl_datum, x->cl_meas_id, x->cl_fbcnt, x->cl_ftimes, 
			 x->cl_next, x->cl_last, x->cl_fbranch);
E 7
I 4
		printf("\tchord=%d\tstop=%d\thold=%d\n",
D 7
			x->chord_element, x->n_stop, x->n_hold);
E 7
I 7
			x->cl_chord, x->cl_stop, x->cl_hold);
E 7
	}
E 4
	return(0);
}

/*
 * newnod - make new node on cyclic list, link it to list header if it is
 * first, else link it to the end of the list
 */

D 7
struct notnod *
E 7
I 7
struct clist_cl *
E 7
newnod(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
D 7
	register struct notnod *x; 
E 7
I 7
	register struct clist_cl *x; 
E 7
	
D 7
	if ((x = (struct notnod *) calloc(1, (unsigned) sizeof(struct notnod)))
E 7
I 7
	if ((x = (struct clist_cl *) calloc(1, (unsigned) sizeof(struct clist_cl)))
E 7
		== NULL)
			malerr("newnod", 1);

D 7
	if (h->nh == NULL)
		h->nh = x;
E 7
I 7
	if (h->hcl_nh == NULL)
		h->hcl_nh = x;
E 7
	else
D 7
		h->np->nxtnot = x;
	x->lstnot = h->np; 
	h->np = x;
	h->nt = x;
	x->nxtnot = NULL;
E 7
I 7
		h->hcl_np->cl_next = x;
	x->cl_last = h->hcl_np; 
	h->hcl_np = x;
	h->hcl_nt = x;
	x->cl_next = NULL;
E 7
	return(x);
}

/*
 * notlnk -	parse cyclic list string into Finite State Automaton
 * takes:
D 7
 * 	h -	pointer to noteheader structure to store FSA
E 7
I 7
 * 	h -	pointer to headcl_hcl structure to store FSA
E 7
 * 	str -	string to parse into FSA
 */

notlnk(h, str, andflag)
D 7
	register struct noteheader *h; 
E 7
I 7
	register struct headcl_hcl *h; 
E 7
	register char *str;
	int andflag;
{
	extern char		*strcpy();
	extern char		*index();
D 7
	extern struct notnod 	*newnod(), 
E 7
I 7
	extern struct clist_cl 	*newnod(), 
E 7
				*interplist();
D 7
	register struct notnod 	*x, 
E 7
I 7
	register struct clist_cl 	*x, 
E 7
				*y; 
	static int 		nest;
	register char 		paren = 0, 
				*c; 
	char			nullc = '\0';

	if (!strlen(str)) {
		fprintf(stderr, "notlnk: null string\n");
D 5
		exit(1);
E 5
I 5
		Pexit(1);
E 5
	}
	c = str;
	x = newnod(h);
	while (*str != '\0' && isspace(*str)) 
		str++;
	while (*str == '{' && *str != '\0') {	/* first thing is '{' */
		paren = *str++;			/* we're parsing a motive */
D 7
		x->f_bcnt = ++nest;		/* record cnt for loop back */
E 7
I 7
		x->cl_fbcnt = ++nest;		/* record cnt for loop back */
E 7
		x = newnod(h);			/* step into next node */
		while (*str != '\0' && isspace(*str)) 
			str++;
	}
/*
 * 	if (*str == '}' ) {
 * 		fprintf(stderr, "notlnk: null node in string: %s\n", c);
 * 	}
 */
	/* make c point to 1'st char after note to be played */
	if ((c = index(str, '}' )) != NULL) {	/* terminates motive */
		paren = *c;
		*c = '\0';		/* null to capture note */
	} else
		c = &nullc;
	if (*str == '@') {		/* '@' == this is a label */
		x = interplist(h, str+1);
	}
	else {				/* a simple note */
		if (*str == '|') {	/* a measure marker */
D 7
			if ((x->measure_id = (char *) malloc((unsigned)
E 7
I 7
			if ((x->cl_meas_id = (char *) malloc((unsigned)
E 7
				strlen(str)+1)) == NULL)
					malerr("notlnk", 1);
D 7
			(void) strcpy(x->measure_id, str);
			x->datum = NULL;
E 7
I 7
			(void) strcpy(x->cl_meas_id, str);
			x->cl_datum = NULL;
E 7
		} else {		/* capture the note to play */
D 7
			if ((x->datum = (char *) malloc((unsigned) 
E 7
I 7
			if ((x->cl_datum = (char *) malloc((unsigned) 
E 7
				strlen(str)+1)) == NULL)
					malerr("notlnk", 1);
D 7
			(void) strcpy(x->datum, str);		
E 7
I 7
			(void) strcpy(x->cl_datum, str);		
E 7
I 2
			if (!strcmp(str, HOLDSTR))
D 7
				x->n_hold = 1;
E 7
I 7
				x->cl_hold = 1;
E 7
			else if (!strcmp(str, STOPSTR))
D 7
				x->n_stop = 1;
E 7
I 7
				x->cl_stop = 1;
E 7
I 6
			else if (!strcmp(str, KILLSTR))
D 7
				x->n_kill = 1;
E 7
I 7
				x->cl_kill = 1;
E 7
E 6
E 2
			if (andflag)
D 7
				x->chord_element = 1;
E 7
I 7
				x->cl_chord = 1;
E 7
		}
	}
	if (paren == '}' ) 
		*c = paren;			/* put it back */
	/* add branch link? */
	/* close to matching branch destination */
	while (*c == '}' ) {
D 7
		for (y = x; y != NULL; y = y->lstnot) {	/* search backwards */
			if (y->f_bcnt == nest) {	/* to same nest level */
				y->f_bcnt = 0;
E 7
I 7
		for (y = x; y != NULL; y = y->cl_last) {	/* search backwards */
			if (y->cl_fbcnt == nest) {	/* to same nest level */
				y->cl_fbcnt = 0;
E 7
				break;			/* y is branch dest */
			}
		}
		if (y == NULL) {
			fprintf(stderr, "notlnk: unballanced curly-braces\n");
D 5
			exit(1);
E 5
I 5
			Pexit(1);
E 5
		}
		/* make dummy node to point to destination */
		x = newnod(h);
D 7
		x->f_branch = y;
		y->b_branch = x;
E 7
I 7
		x->cl_fbranch = y;
		y->cl_bbranch = x;
E 7
		c++;					/* step past paren */
		while(isspace(*c)) 
			c++;				/* and white space */
		if (*c == 'x')				/* set rept count */
# ifdef NOTDEF
D 7
			y->b_bcnt = y->b_times = 
				x->f_bcnt = x->f_times = atoi(c+1);
E 7
I 7
			y->cl_bbcnt = y->cl_btimes = 
				x->cl_fbcnt = x->cl_ftimes = atoi(c+1);
E 7
# endif NOTDEF
D 7
			y->b_times = x->f_times = atoi(c+1);
E 7
I 7
			y->cl_btimes = x->cl_ftimes = atoi(c+1);
E 7
		if ((c = index(c, '}' )) == NULL)	/* any more to do? */
			c = &nullc;
		nest--;
	}
}

char *
getlesser(n, l)
	register char *n, *l;
{
	if (n == 0) 
		n = l;
	if (l == 0) 
		l = n;
	return(n < l ? n : l);
}

/*
 * buildnotes -	build Finite State Automaton from string
 * takes:
D 7
 * 	h -	noteheader structure to stuff FSA on
E 7
I 7
 * 	h -	headcl_hcl structure to stuff FSA on
E 7
 * 	nl -	string to parse into FSA
 * side effects:
 * 	Installs cyclic list label (if any) into ST_CYCLABL symbol table.
 * 	Installs nl into ST_CYCLABL symbol table.
 */

buildnotes(h, nl)
D 7
	register struct noteheader 	*h; 
E 7
I 7
	register struct headcl_hcl 	*h; 
E 7
	register char 			*nl;
{
	extern char	*index(); 
	register char 	*l, 
			*m,
			*n, 
			*o, 
			*save, 
			*tmp;
	register int 	cnt = 0,
			andflag = 0;

	if (_Pdebug & CYCLIST)
		fprintf(stderr, "buildnotes:h=%x nl=|%s|\n", h, nl);
	/* squirl away a copy */
D 7
	if ((h->raw = (char *) malloc((unsigned) strlen(nl)+1)) == NULL)
E 7
I 7
	if ((h->hcl_raw = (char *) malloc((unsigned) strlen(nl)+1)) == NULL)
E 7
		malerr("buildnotes", 1);
D 7
	(void) strcpy(h->raw, nl);
E 7
I 7
	(void) strcpy(h->hcl_raw, nl);
E 7
	if ((tmp = (char *) malloc((unsigned) strlen(nl)+1)) == NULL)
			malerr("buildnotes", 1);
	(void) strcpy(tmp, nl);
	nl = tmp;
	while (*nl != NULL && isspace(*nl)) 
		nl++;
	if (*nl == '\0')	/* nothing but whitespace or null? */
		return(1);
I 6
	newnod(h);		/* dummy node for first-time allignment */
E 6
	for (n = nl; *n != '\0'; ) {
		save = n;
D 3
		n = index(save, ',');
		for (l = save; *l != '\0'; l++) {
			if (isspace(*l)) 
				break;
			if (*l == '&') {
E 3
I 3
		/* find nearest terminator */
D 4
		for ( ; *n != '\0' && !(*n == ',' || isspace(*n)); n++) {
			if (*n == '&')	/* look for '&' while we are at it */
E 3
				andflag = 1;
D 3
				break;
			}
E 3
		}
D 3
		if (*l == '\0') 
			l = NULL;
		n = getlesser(n, l); 	/* find nearest terminator */
		if (n != NULL)
E 3
I 3
		if (n != '\0')
E 3
		    if (*n != ',') {	/* terminator not comma? */
E 4
I 4
		for ( ; *n != '\0' && !(*n == ',' || isspace(*n)); n++)
			continue;
		/* we have a terminated expression, n points to terminator */
		if (*n != '\0') {
		    if (*n != ',') { /* terminator not comma? */
E 4
			/* look ahead for possible '&' */
			for (l = n; *l != '\0' && isspace(*l); l++)
D 3
				/* empty */ ;
E 3
I 3
				continue;
E 3
			if (*l == '&') {
				andflag = 1;
				*l = ' ';
			}
D 4
		    } 
D 3
		if (n != NULL) 
E 3
I 3
		if (n != '\0') 
E 4
I 4
		    }
		}
		if (*n != '\0') 	/* step n to next expr. */
E 4
E 3
			*n++ = NULL;
		if (cnt == 0 && (o = index(save, ':')) != NULL) { /* labeled? */
			*o = NULL;	/* zap the ':' */
D 7
			if ((h->nn = (char *)malloc((unsigned)
E 7
I 7
			if ((h->hcl_nn = (char *)malloc((unsigned)
E 7
				strlen(save)+1)) == NULL)
					malerr("buildnotes", 1);
			/* save label */
D 7
			(void) strcpy(h->nn, save);
E 7
I 7
			(void) strcpy(h->hcl_nn, save);
E 7
			/* put it in symtab */
			if (install(save, AT_CYCLABL, (char *) h) == NULL) {
				fprintf(stderr, "buildnotes: install failed\n");
D 5
				exit(1);
E 5
I 5
				Pexit(1);
E 5
			}
			if (_Pdebug & CYCLIST)
				fprintf(stderr, 
				    "buildnotes:label=|%s| raw=|%s|\n", 
D 7
				    h->nn, h->raw);
E 7
I 7
				    h->hcl_nn, h->hcl_raw);
E 7
		}
D 4
		else
			notlnk(h, save, andflag);
E 4
I 4
		else {
			if (!strcmp(save, "&")) {
D 7
				h->np->chord_element = 1;
E 7
I 7
				h->hcl_np->cl_chord = 1;
E 7
				cnt--;
			} else
				notlnk(h, save, andflag);
		}
E 4
		cnt++;
		andflag = 0;
		if (n != NULL) {
			while (*n != '\0' && (isspace(*n) || *n == ',')) 
				n++;
		} else
			break;
	}
D 7
	h->Nnotes = cnt;
	h->np = h->nh; 	/* reset to head */
	h->incr = 1;	/* default traversal vector */
E 7
I 7
	h->hcl_len = cnt;
	h->hcl_np = h->hcl_nh; 	/* reset to head */
	h->hcl_incr = 1;	/* default traversal vector */
E 7
	rebuild_list(h);	/* initialize it */
	Player_stat &= ~P_WRAP;	/* undo side effect of rebuild_list() */
	free(tmp);
	return(0);
}

/*
 * rebuild_list -	reset sublist repeat counts for FSA
 * takes:
 * 	h - address of cyclic list structure
 * returns:
 * 	nothing
 * side effects:
 * 	sets Player_stat to P_WRAP to indicate a cyclic list has
 * 	wrapped around.
 * 	
 */

rebuild_list(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
D 7
	register struct notnod *x;
E 7
I 7
	register struct clist_cl *x;
E 7

D 7
	for (x = h->nh; x != NULL; x = x->nxtnot ) {
		x->f_bcnt = x->f_times;
		x->b_bcnt = x->b_times;
E 7
I 7
	for (x = h->hcl_nh; x != NULL; x = x->cl_next ) {
		x->cl_fbcnt = x->cl_ftimes;
		x->cl_bbcnt = x->cl_btimes;
E 7
	}
	Player_stat |= P_WRAP;
}

D 8
/*
 * Direction - set direction of FSA traversal
 * takes:
 *	x -	string address of cyclic list
 *	increment - set direction and step size  
 */
E 8

D 8
Direction(x, increment)
	register char *x;
	register int increment;
{
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
	register struct hlist *hl;

	Player_stat &= ~P_NULL_PTR;
	if ((hl = lookup(x, AT_CYCLIST)) == NULL) {
		Player_stat |= P_NULL_PTR;
		return(0);
	}
	if ((h = hl->hl_val.st_cycl) != NULL) {
D 7
		register int dir = h->incr;
E 7
I 7
		register int dir = h->hcl_incr;
E 7

D 7
		h->incr = increment;
E 7
I 7
		h->hcl_incr = increment;
E 7
		return(dir);
	}
	Player_stat |= P_NULL_PTR;
	return(0);
}

E 8
initnot(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
	Player_stat &= ~P_MEAS;
D 7
	while (h->np->datum == NULL) {
		if (h->np->measure_id != NULL)
E 7
I 7
	while (h->hcl_np->cl_datum == NULL) {
		if (h->hcl_np->cl_meas_id != NULL)
E 7
			Player_stat |= P_MEAS;
D 7
		h->np = h->np->nxtnot;
E 7
I 7
		h->hcl_np = h->hcl_np->cl_next;
E 7
	}
	return(Player_stat & P_MEAS);
}

/*
 * nextnot - fetch next element from FSA
 * returns: 
 *	number of measures that elapse on this call
 * side effects:
 *	sets Player_status to P_WRAP if the cyclic list wrapped around
 */

nextnot(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
	if (h != NULL) {
D 7
		register int cnt = h->incr;
E 7
I 7
		register int cnt = h->hcl_incr;
E 7

D 2
		Player_stat &= ~(P_WRAP | P_MEAS);
E 2
		if (cnt > 0) {
			while (cnt-- > 0)
				if (foreward(h) != 0)
					Player_stat |= P_MEAS;
		} else if (cnt < 0) {
			while (cnt++ < 0)
				if (backward(h) != 0)
					Player_stat |= P_MEAS;
		}
		return(Player_stat & P_MEAS);
	} else {
		Player_stat |= P_NULL_PTR;
		return(0);
	}
}

/*
 * foreward -	step forewards through FSA, wraping around at end
 */

foreward(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
	register int rtn = 0;

D 7
skip: 	if (h->np->measure_id != NULL)
E 7
I 7
skip: 	if (h->hcl_np->cl_meas_id != NULL)
E 7
		rtn = 1;
D 7
	if (h->np->f_times > 0) {
		if (--h->np->f_bcnt > 0) {
E 7
I 7
	if (h->hcl_np->cl_ftimes > 0) {
		if (--h->hcl_np->cl_fbcnt > 0) {
E 7
			/* step into branch */
D 7
			h->np = h->np->f_branch;
E 7
I 7
			h->hcl_np = h->hcl_np->cl_fbranch;
E 7
		}
		else {
			/* reset loop count */
D 7
			h->np->f_bcnt = h->np->f_times;
E 7
I 7
			h->hcl_np->cl_fbcnt = h->hcl_np->cl_ftimes;
E 7
			/* step along main list */
D 7
			h->np = h->np->nxtnot;
E 7
I 7
			h->hcl_np = h->hcl_np->cl_next;
E 7
		}
	}
	else {
D 7
		h->np = h->np->nxtnot;
E 7
I 7
		h->hcl_np = h->hcl_np->cl_next;
E 7
	}
D 7
	if (h->np == NULL) {		/* hit end of list */
		h->np = h->nh;		/* start at top again */
E 7
I 7
	if (h->hcl_np == NULL) {		/* hit end of list */
		h->hcl_np = h->hcl_nh;		/* start at top again */
E 7
		rebuild_list(h);	/* reinit loop counts on list */
	}
D 7
	if (h->np->f_times > 0)
E 7
I 7
	if (h->hcl_np->cl_ftimes > 0)
E 7
		goto skip;		/* skip back to take branch */
D 7
	if (h->np->datum == NULL) {
E 7
I 7
	if (h->hcl_np->cl_datum == NULL) {
E 7
# ifdef NOTDEF
D 7
		if (h->np->measure_id != NULL)
E 7
I 7
		if (h->hcl_np->cl_meas_id != NULL)
E 7
			rtn = 1; 	/* signal end of measure upon return */
# endif NOTDEF
		goto skip;		/* skip ahead to next valid node */
	}
	return(rtn);
}

/*
 * backward -	step backwards in FSA, wraping around if necessary
 */

backward(h)
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7
{
	register int rtn = 0;

D 7
skip: 	if (h->np->b_times > 0) {
		if (--h->np->b_bcnt > 0) {
E 7
I 7
skip: 	if (h->hcl_np->cl_btimes > 0) {
		if (--h->hcl_np->cl_bbcnt > 0) {
E 7
			/* step into branch */
D 7
			h->np = h->np->b_branch;
E 7
I 7
			h->hcl_np = h->hcl_np->cl_bbranch;
E 7
		}
		else {
			/* reset loop count */
D 7
			h->np->b_bcnt = h->np->b_times;
E 7
I 7
			h->hcl_np->cl_bbcnt = h->hcl_np->cl_btimes;
E 7
			/* step along main list */
D 7
			h->np = h->np->lstnot;
E 7
I 7
			h->hcl_np = h->hcl_np->cl_last;
E 7
		}
	}
	else {
D 7
		h->np = h->np->lstnot;
E 7
I 7
		h->hcl_np = h->hcl_np->cl_last;
E 7
	}
D 7
	if (h->np == NULL) {		/* hit end of list */
		h->np = h->nt;		/* start at end again */
E 7
I 7
	if (h->hcl_np == NULL) {		/* hit end of list */
		h->hcl_np = h->hcl_nt;		/* start at end again */
E 7
		rebuild_list(h);	/* reinit loop counts on list */
	}
D 7
	if (h->np->b_times > 0)
E 7
I 7
	if (h->hcl_np->cl_btimes > 0)
E 7
		goto skip;	/* skip back to take branch */
D 7
	if (h->np->datum == NULL) {
		if (h->np->measure_id != NULL)
E 7
I 7
	if (h->hcl_np->cl_datum == NULL) {
		if (h->hcl_np->cl_meas_id != NULL)
E 7
			rtn = 1; 	/* signal end of measure upon return */
		goto skip;		/* skip ahead to next valid node */
	}
	return(rtn);
}

/*
D 7
 * _motive -	fetch (or initialize and install) noteheader
E 7
I 7
 * _motive -	fetch (or initialize and install) headcl_hcl
E 7
 */

_motive(h, nl)
D 7
	register struct noteheader *h; 
E 7
I 7
	register struct headcl_hcl *h; 
E 7
	register char *nl;
{
	if (h == NULL) {
D 7
		fprintf(stderr, "_motive: NULL noteheader\n");
E 7
I 7
		fprintf(stderr, "_motive: NULL headcl_hcl\n");
E 7
D 5
		exit(1);
E 5
I 5
		Pexit(1);
E 5
	}
D 7
	if (h->Nnotes == 0)
E 7
I 7
	if (h->hcl_len == 0)
E 7
		(void) buildnotes(h, nl);
}

/*
D 7
 * newid -	install new noteheader
E 7
I 7
 * newid -	install new headcl_hcl
E 7
 */

D 7
struct noteheader *
E 7
I 7
D 8
struct headcl_hcl *
E 7
newid(x)
E 8
I 8
struct headcl_hcl *newid(x)
E 8
	register char *x;
{
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7

	if (_Pdebug & CYCLIST)
		fprintf(stderr, "newid:new=|%s|\n", x);
D 7
	if ((h = (struct noteheader *) calloc(1, 
		(unsigned) sizeof(struct noteheader))) == NULL)
E 7
I 7
	if ((h = (struct headcl_hcl *) calloc(1, 
		(unsigned) sizeof(struct headcl_hcl))) == NULL)
E 7
			malerr("newid", 1);
	if (install(x, AT_CYCLIST, (char *) h) == NULL) {
		fprintf(stderr, "newid: install failed\n");
D 5
		exit(1);
E 5
I 5
		Pexit(1);
E 5
	}
I 2
D 7
	h->h_metronome = 1.0;
E 7
I 7
	h->hcl_metro = 1.0;
E 7
E 2
	return(h);
}

/*
D 7
 * getid -	fetch noteheader from cyclic list string address
E 7
I 7
 * getid -	fetch headcl_hcl from cyclic list string address
E 7
 */

D 7
struct noteheader *
E 7
I 7
struct headcl_hcl *
E 7
getid(x)
	register char *x;
{
	register struct hlist *hl;

	if (_Pdebug & CYCLIST)
		fprintf(stderr, "getid:x=%x\n", x);

	if ((hl = lookup(x, AT_CYCLIST)) == NULL)
		return(newid(x));
	if (_Pdebug & CYCLIST)
		fprintf(stderr, "getid:old=|%s|\n", x);
	return(hl->hl_val.st_cycl);
D 8
}


/*
 * Motive -	parse and install cyclic list string in symbol table
 * takes:
 * 	c -	cyclic list string address
 * side effects:
 * 	Parses cyclic list string into Finite State Automaton.
 * 	Places the FSA in a symbol table in two places:
 * 		- indexed by the cyclic list string address, and
 * 		- indexed by the cyclic list string label, if any.
 */

Motive(c)
	register char *c;
{
D 7
	register struct noteheader *h;
E 7
I 7
	register struct headcl_hcl *h;
E 7

	h = newid(c);
	_motive(h, c);
E 8
}
E 1
