h59244
s 00039/00022/00015
d D 2.2 86/01/30 16:34:32 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00001/00001/00036
d D 2.1 85/10/26 23:39:46 dgl 4 3
c changed variable names.
e
s 00019/00012/00018
d D 1.3 85/10/14 15:44:23 dgl 3 2
c prettified P_FLOAT code.
e
s 00006/00002/00024
d D 1.2 85/10/01 16:38:58 dgl 2 1
c now allows backwards time refs. in integer players.
e
s 00026/00000/00000
d D 1.1 84/12/21 12:05:38 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
I 5
#include "debug.h"
E 5

D 5
/*
 * Wait_until -	schedule Player to run at a certain time
 * takes:
 * 	Self -	uses global ptr. to current instance implicitly
D 3
 *	time - time in absolute seconds; beginning at == 0
 * returns:	
 *	-1 if waiting until a time that has already passed, 0 otherwise
E 3
I 3
 * time - time in absolute seconds; beginning at == 0
 * Note:
 * Backwards time references are updated to the current value of Now.
 * If P_FLOAT is defined, then backward time references are silently
 * updated to the present; else, a warning message is generated:
 * 	"Wait_until: backwards time reference".
E 3
 */
E 5

D 3
Wait_until(time)
E 3
D 5
# ifdef P_FLOAT
D 3
	register double time;
# else
	register long time;
E 3
I 3
#	define TYPE double
#	define ZERO 0.0
# else P_FLOAT
#	define TYPE long
#	define ZERO 0
E 3
# endif P_FLOAT
I 3

E 5
Wait_until(time)
D 5
	register TYPE time;
E 5
I 5
	register P_TYPE time;
/*
 * Schedule Player to run at a certain time.
 * .LP
 * Takes time in absolute units, beginning at 0, schedules Player
 * named by global Player pointer \fBSelf\fP to run at that time.
 * Backwards time references are updated to the current value of \fBNow\fP.
 * .LP
 * When a Player is run as a result of calling Wait_until(),
 * the \fBP_WAIT_UNTIL\fP bit in the \fBPlayer_stat\fP global
 * status register will be set.  The bit is cleared by the scheduler
 * when the Player returns.
 * .LP
 * Returns 0 on success, -1 if the request lies beyond the end
 * of the Player's window.  Players requesting to be run beyond their
 * window are Kill()'ed (when they finally return to the scheduler).
 * .LP
 * Diagnostics, in timesharing version only:
 * 'Wait_until: backwards time reference'.
 */
E 5
E 3
{
I 5
	extern void set_wait();
	if (Self->P_dur >= 0) {	/* it has a specific duration window? */
		/* has it run its span? */
		if (Self->P_et == P_GT 
		    ? Self->P_time + time > Self->P_beg + Self->P_dur
		    : Self->P_time + time >= Self->P_beg + Self->P_dur) {
# ifdef P_DEBUG
			if (_Pdebug & RUN_ARBITER) 
			    fprintf(stderr, 
				"run_arbiter: killing %s:%x\n",
				Self->P_name, Self);
# endif P_DEBUG
			Self->P_runstat = P_STUNNED;
			return(-1);
		}
	}
E 5
D 2
	if (Now > time)
		return(-1);
E 2
I 2
D 3
	if (Now > time)		/* past tense? */
E 3
I 3
	if (Now > time) {	/* past tense? */
E 3
# ifdef P_FLOAT
D 3
		return(-1);	/* complain about backward time */
# else P_FLOAT
		time = Now;	/* force to be present tense */
E 3
I 3
		fprintf(stderr, "Wait_until: backwards time reference\n");
E 3
# endif P_FLOAT
I 3
		time = Now;	/* force to be present tense */
	}
E 3
E 2
D 4
	Self->ptime = time;
E 4
I 4
	Self->P_time = time;
E 4
D 5
	set_wait(Self, time);
D 3
	return(0);
E 3
I 3
	return(ZERO);
E 5
I 5
	set_wait(Self, time, P_WU);
	return(0);
E 5
E 3
}
E 1
