h03988
s 00042/00027/00098
d D 2.2 86/01/30 16:34:26 dgl 6 5
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00000/00000/00125
d D 2.1 85/10/26 23:39:43 dgl 5 4
c changed variable names.
e
s 00003/00003/00122
d D 1.4 85/09/20 16:14:28 dgl 4 3
c exit() is now Pexit().
e
s 00002/00002/00123
d D 1.3 85/09/10 12:11:53 dgl 3 2
c fixed list linkage in Wait_for (how did it ever work before???)
e
s 00000/00001/00125
d D 1.2 85/09/10 11:17:05 dgl 2 1
c removed break in wf_clear() which caused premature exit.
e
s 00126/00000/00000
d D 1.1 84/12/21 12:05:29 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

static Player *poll;

D 6
/*
 * Wait_for - 	cause Player to wait for an event
 * takes:	
 *	Self 	- picked up globally
 *	proc 	- address of decision procedure
 * 	status 	- one-shot or continuous
 * 		ONCE == wait for event one time 
 * 		CONTINUOUS == wait for event continuously
 * returns:	nothing
 * side effects: 
 *	If no waits in progress, start builtin Player poll_waits.
 * 	Install Self and proc in ST_WAIT_FOR hashing symbol table,  also
 * 	link symbol table element to linked list of all Wait_for elements.
 */

Wait_for(proc, status)
E 6
I 6
void Wait_for(proc, status)
E 6
	register int (*proc)();
	register int status;
I 6
/*
 * Cause Player to wait for an event.
 * .LP
 * 'proc' is the address of a decision procedure which determines
 * whether the process named by \fBSelf\fP should be awakened.
 * 'status' determines whether the decision procedure is
 * called once only or repeatedly.
 * 'status' takes one of two values:
 * .RS
 * .TP 18
 * \fBONCE\fP 
 * wait for event one time.
 * .TP 18
 * \fBCONTINUOUS\fP
 * wait for event continuously.
 * .RE
 * The decision procedure should return \fBTrue\fP if the waiting
 * Player should be run, \fBFalse\fP otherwise.
 * .LP
 * When a Player is scheduled to run by a decision procedure returning
 * \fBTrue\fP, the \fBP_WAIT_FOR\fP bit in the \fBPlayer_stat\fP global
 * status register will be set.  The bit is cleared by the scheduler
 * when the Player returns.
 * .LP
 * In timesharing version,
 * if no waits are in progress, the built-in Player \fBpoll_waits\fP
 * is does not run.  The first call to \fBWait_for\fP instantiates
 * \fBpoll_waits\fP.  When the cueue of waiting Players empties,
 * \fBpoll_waits\fP is terminated.
 * In realtime version, the mechanism is handled by a routine called by
 * clock interrupt which also is a time server, so it always runs.
 */
E 6
{
	register struct wait_f *p;

	if ((p = (struct wait_f *) 
		malloc((unsigned) sizeof(struct wait_f))) == NULL)
			malerr("Wait_for", 1);
	p->f_proc = proc;
	p->f_pp = Self;
	p->f_flag = status;
	if (wlist == NULL) {	/* no waits in progress */
		p->f_next = p->f_last = NULL;
		/* start up the poller */
		if ((poll = New_player(poll_waits, Now, HUGE, P_READY))==NULL){
			fprintf(stderr, "Wait_for: New_player failed\n");
D 4
			exit(1);
E 4
I 4
			Pexit(1);
E 4
		}
	} else {
D 3
		p->f_next = wlist->f_next;
		p->f_last = wlist;
E 3
I 3
		wlist->f_last = p;
		p->f_next = wlist;
E 3
	}
	wlist = p;
}

D 6
/*
 * Unwait_for -	cause Player to no longer wait for an event
 * takes:		
 *	Self 	- picked up globally
 *	proc 	- address of decision procedure
 * returns:	
 *	-1 if proc not found in symbol table, otherwise 0
 * side effects:	
 *	Removes proc from linked list of Wait_for elements.
 *	Removes symbol from WAIT_FOR symbol table.
 */
E 6

Unwait_for(proc)
	register int (*proc)();
I 6
/*
 * Cause Player to no longer wait for an event.
 * .LP
 * 'proc' is the
 * address of the decision procedure given to \fBWait_for\fP.
 * Returns
 * \-1 if 'proc' is not found, otherwise 0 on success.
 * Removes 'proc' from linked list of \fBWait_for\fP elements.
 */
E 6
{
	register struct wait_f *p;

	for (p = wlist; p != NULL; p = p->f_next) {
		if (p->f_proc == proc && p->f_pp == Self) {
			/* patch around this on wlist */
			if (p->f_last != NULL)
				p->f_last->f_next = p->f_next;
			if (p->f_next != NULL)
				p->f_next->f_last = p->f_last;
			if (wlist == p)
				wlist = p->f_next;
			free((char *) p);
			break;
		}
	}
	if (wlist == NULL) {
		if (poll != NULL)
			if (Kill(poll) == P_NOSTAT) {
				fprintf(stderr, 
					"Unwait_for: Kill(poll) failed\n");
D 4
				exit(1);
E 4
I 4
				Pexit(1);
E 4
			}
	}
	return(0);
}

/*
 * wf_clear - delete all references to Player x from wlist
 * takes:
 * 	x -	Player to remove all wait_for's
 * notes:
 * 	used by garbage collector to clean up after Kill()ed voice.
 */

wf_clear(x)
	Player *x;
{
	register struct wait_f *p;

	for (p = wlist; p != NULL; p = p->f_next) {
		if (p->f_pp == x) {
			/* patch around this on wlist */
			if (p->f_last != NULL)
				p->f_last->f_next = p->f_next;
			if (p->f_next != NULL)
				p->f_next->f_last = p->f_last;
			if (wlist == p)
				wlist = p->f_next;
			free((char *) p);
D 2
			break;
E 2
		}
	}
	if (wlist == NULL) {
		if (poll != NULL && x != poll) {
			if (Kill(poll) != 0) {
				fprintf(stderr, 
					"wf_clear: Kill(poll) failed\n");
D 4
				exit(1);
E 4
I 4
				Pexit(1);
E 4
			}
			poll = NULL;
		}
	}
	return(0);
}
E 1
