h58226
s 00022/00022/00046
d D 2.2 86/01/30 16:33:03 dgl 7 6
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00011/00011/00057
d D 2.1 85/10/26 23:38:52 dgl 6 5
c changed variable names.
e
s 00008/00003/00060
d D 1.4 85/10/11 12:13:22 dgl 5 3
c added Kill directive.
e
s 00009/00003/00060
d R 1.4 85/10/10 16:51:51 dgl 4 3
c Added ``Kill'' cyclic list directive.
e
s 00001/00001/00062
d D 1.3 85/09/30 13:54:55 dgl 3 2
c changed comment.
e
s 00012/00012/00051
d D 1.2 85/03/13 23:01:55 dgl 2 1
c Overhaul of status reporting to caller.
e
s 00063/00000/00000
d D 1.1 84/12/21 12:05:06 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

D 7
/*
 * Strings -	evaluate cyclic list as String fields
 * takes:	
 *	nl -	pointer to string of String fields in cyclic list format
 * returns:	
 *	pointer to String field
 * side effects:	
 *	Increments pointer to next expression field.
 * 	Sets Player_stat:
 * 		to P_HOLD_SET if expr == HOLDSTR
 * 		to P_STOP_SET if expr == STOPSTR
I 5
 * 		to P_KILL_SET if expr == KILLSTR
E 5
 * notes:	
D 5
 *	May stop Player if expr == STOPSTR.
E 5
I 5
 *	Will stop Player if expr == STOPSTR.
 *	Will kill Player if expr == KILLSTR.
E 5
 *	Returns last value if HOLDSTR is set and does not increment
 *		pointer to next expr field.
 *	Strips off `"' marks around string fields; in this way,
 *		HOLDSTR and STOPSTR can be passed by quotation.
 */
E 7

D 7
char *
Strings(nl)
E 7
I 7
char * Strings(nl)
E 7
	register char *nl;
I 7
/*
 * Evaluate string as cyclic list of \fBString\fP expressions.
 * .LP
 * Takes pointer to string of \fBString\fP expressions in cyclic list format.
 * Returns pointer to string containing the current \fBString\fP field.
 * Increments pointer to next expression field.
 * Sets \fBPlayer_stat\fP:
 * .in +5
 * .nf
 * to \fBP_HOLD_SET\fP 'if expr ==' \fBHOLDSTR\fP,
 * to \fBP_STOP_SET\fP 'if expr ==' \fBSTOPSTR\fP,
 * to \fBP_KILL_SET\fP 'if expr ==' \fBKILLSTR\fP.
 * .in -5
 * .fi
 * Will stop Player 'if expr ==' \fBSTOPSTR\fP.
 * Will kill Player 'if expr ==' \fBKILLSTR\fP.
 * Returns last value if \fBHOLDSTR\fP is scanned, and does not increment
 * pointer to next expression field.
 * Strips off `\f(CW"\fP' marks around string fields; in this way,
 * \fBHOLDSTR\fP and \fBSTOPSTR\fP can be passed by quotation.
 */
E 7
{
	char	*index();
D 6
	register struct noteheader *h;
E 6
I 6
	register struct headcl_hcl *h;
E 6
	register char 	*rtn, *c; 

D 2
	Player_stat &= ~(P_HOLD_SET | P_STOP_SET);
E 2
	h = getid(nl);
	_motive(h, nl);
D 2
	(void) nextnot(h);
	c = h->np->datum;
	if (!strcmp(HOLDSTR, c)) {
E 2
I 2
	Player_stat &= ~(P_STOP_SET|P_HOLD_SET|P_TIMESIG|P_KEYSIG
D 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD);
E 5
I 5
		|P_WRAP|P_MEAS|P_METRONOME|P_CHORD|P_KILL_SET);
E 5
	if (nextnot(h) != 0)
D 6
		clr_ac(&h->ac_list);
E 6
I 6
		clr_ac(&h->hcl_aclist);
E 6
D 3
	/* note, Strings does not field clist_directives */
E 3
I 3
	/* note, Strings does not field clist directives */
E 3
D 6
	rtn = c = h->np->datum;
D 5
	if (h->np->n_stop) {	/* stop this player */
E 5
I 5
	if (h->np->n_kill) {	/* kill this player */
E 6
I 6
	rtn = c = h->hcl_np->cl_datum;
	if (h->hcl_np->cl_kill) {	/* kill this player */
E 6
		Player_stat |= P_KILL_SET;
D 6
		Self->runstat = P_KILLED;
	} else if (h->np->n_stop) {	/* stop this player */
E 5
		Self->runstat = P_STOPPED;
E 6
I 6
		Self->P_runstat = P_KILLED;
	} else if (h->hcl_np->cl_stop) {	/* stop this player */
		Self->P_runstat = P_STOPPED;
E 6
		Player_stat |= P_STOP_SET;
	}
D 6
	if (h->np->n_hold) {
E 2
		rtn = h->last_val;
E 6
I 6
	if (h->hcl_np->cl_hold) {
		rtn = h->hcl_lastval;
E 6
		Player_stat |= P_HOLD_SET;
	} else {
D 2
		rtn = c;
E 2
D 6
		h->last_val = c;
		if (h->np->chord_element != 0)
E 6
I 6
		h->hcl_lastval = c;
		if (h->hcl_np->cl_chord != 0)
E 6
D 2
			Self->chordstat = TRUE;
		else
			Self->chordstat = FALSE;
	}
	if (!strcmp(rtn, STOPSTR)) {	/* stop this player */
		Self->runstat = P_STOPPED;
		Player_stat |= P_STOP_SET;
E 2
I 2
			Player_stat |= P_CHORD;
E 2
	}
	/* strip off any quotes from string */
	if (*rtn == '"') 
		rtn++;
	c = index(rtn, '\0');
	if (c != NULL) 
		if (*--c == '"') 
			*c = '\0';
	return(rtn);
}
E 1
