h22156
s 00022/00018/00048
d D 2.2 86/01/30 16:37:12 dgl 6 5
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00000/00000/00066
d D 2.1 85/10/26 23:42:01 dgl 5 4
c changed variable names.
e
s 00001/00000/00065
d D 1.4 85/10/14 15:49:57 dgl 4 3
c Pclock now set by default to .1 here.
e
s 00005/00026/00060
d D 1.3 85/10/14 12:20:59 dgl 3 2
c switched calls to M_start and cueue_players,
c and fixed method of calling poll_waits and read_stdin.
e
s 00018/00008/00068
d D 1.2 85/10/01 16:41:26 dgl 2 1
c bugfix re. calling mk_Player.
e
s 00076/00000/00000
d D 1.1 85/10/01 15:59:29 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 3
/* %M%	%I%	(CARL)	%G%	%U% */

E 3
# include <carl/Player.h>
# include "debug.h"

I 6

void Pmain(ac, av)
	int	ac;
	char	**av;
E 6
/*
D 6
 * Pmain -	invoke Player environment
 * side effects:
 * 	Copies its arguments from the shell to global memory.
 * 	Parses flags on command line.
 * 	Cueues Players, 
 * 		Installs Player class templates,
 * 		Instantiates all static Players.
 * 	If stdin is a file or pipe,
 * 		instantiates a builtin Player, read_stdin, to
 * 		read input for cmusic note list style input.
 * 	Instantiates builtin Player poll_waits.
 * 	Runs startup user subroutine M_start().
 * 	Runs the scheduler, run_arbiter().
 * 	Runs the shutdown user subroutine M_ter().
E 6
I 6
 * Invoke Player environment.
 * .LP
 * Takes
 * command line arguments from user's main().
 * Copies its arguments from the shell to global variables
 * \fBargc\fP, and \fBargv\fP.
 * Examines flags on command line.
 * Cueues Players (installs Player class templates, 
 * instantiates all autonomous Players).
 * In timesharing version,
 * if 'stdin' is a file or pipe,
 * instantiates a builtin Player, \fBread_stdin\fP, to
 * read input for cmusic note list style input.
 * In timesharing version,
 * instantiates builtin Player \fBpoll_waits\fP.
 * Runs startup user subroutine \fBM_start()\fP.
 * Runs the scheduler, and when it returns,
 * runs the shutdown user subroutine \fBM_ter()\fP, and returns.
E 6
 */
D 6

D 3
main(ac, av)
	char **av;
{

	Pmain(ac, av);
}



E 3
I 3
void
E 3
Pmain(ac, av)
	char **av;
E 6
{
	extern Player *end_game();
D 3
	register Player *c;
E 3

I 4
	Pclock = .1;		/* set polling clock interval */
E 4
	cpy_args(ac, av);
	parse_flags(ac, av);
	Out_proc = OUTPROC;
D 3
	M_start();
E 3
	cueue_players();
I 3
	M_start();
E 3

	/* sprout Player to read input? */
	if (!isatty(0)) { 	/* is there input? */
I 2
		Player	*p = (Player *) calloc(1, sizeof(Player));

		if (p == NULL)
			Pexit(1);
E 2
D 3
		/* get class structure */
D 2
		if ((c = mk_Player(read_stdin)) == NULL) {
E 2
I 2
		if ((c = mk_Player(p)) == NULL) {
E 2
			fprintf(stderr, "mk_Player failed\n");
			Pexit(1);
		}
E 3
		/* stuff class structure */
D 3
		PC_read_stdin(c);
E 3
I 3
		PC_read_stdin(p);
E 3
		/* make runnable instance */
		if (New_player(read_stdin, 0.0, HUGE, P_READY) ==NULL)
			Pexit(1);
	}

D 2
	/* create poll_waits Player class template */
	/* get class structure */
	if ((c = mk_Player(poll_waits)) == NULL) {
		fprintf(stderr, "mk_Player failed\n");
		Pexit(1);
E 2
I 2
	{
		Player	*p = (Player *) calloc(1, sizeof(Player));

		if (p == NULL)
			Pexit(1);
		/* create poll_waits Player class template */
D 3
		/* get class structure */
		if ((c = mk_Player(p)) == NULL) {
			fprintf(stderr, "mk_Player failed\n");
			Pexit(1);
		}
E 3
		/* stuff class structure */
D 3
		PC_poll_waits(c);
E 3
I 3
		PC_poll_waits(p);
		/* but don't make runnable instance yet */
E 3
E 2
	}
D 2
	/* stuff class structure */
	PC_poll_waits(c);
E 2

	run_arbiter();
	M_ter();
# ifdef P_DEBUG
	if (_Pdebug & SYMTAB)
		stat_symtab();
# endif P_DEBUG
D 3
	Pexit(0);
E 3
}
E 1
