h33277
s 00007/00015/00023
d D 2.1 86/01/30 16:39:35 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00038/00000/00000
d D 1.1 85/11/06 12:38:12 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

extern double Scale[];

double Pitch(str)
D 2
	register char *str;
E 2
I 2
	register char *str;	/* pointer to string of Pitch expressions */
E 2
/*
D 2
 * Evaluate string as Pitch expression.
 * .TP
 * Takes:	
 * pointer to string containing Pitch expression.
 * .TP
 * Returns:	
 * pitch in Hz of evaluated string.
 * .TP
 * Side effects: 
 * Sets Player_stat to P_REST_SET if expr == RESTR.
 * .TP
 * Notes:	
 * Does nothing with Stop, Kill or Hold.
 * Returns 1.0 if expression == RESTR.
E 2
I 2
 * Evaluate string as \fBPitch\fP expression.
 * .LP
 * Returns pitch in Hz of evaluated string.
 * Sets \fBPlayer_stat\fP to \fBP_REST_SET\fP 'if expr ==' \fBRESTR\fP.
 * Does not understand \fBStop\fP, \fBKill\fP or \fBHold\fP.
 * Returns 1.0 'if expression ==' \fBRESTR\fP.
E 2
 */
{
	float oct;
	register int pc;
	
	pc = pc_oct(str, &oct, NULL);

	if (Player_stat & (P_REST_SET|P_EXPR_ERR) == 0)
		return(Scale[pc] * pow(2.0, (double) oct));
	else
		return(1.0);
}
E 1
