h09430
s 00019/00014/00023
d D 2.2 86/01/30 16:31:52 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00004/00004/00033
d D 2.1 85/10/26 23:38:01 dgl 2 1
c changed variable names.
e
s 00037/00000/00000
d D 1.1 84/12/21 12:01:33 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <carl/Player.h>

D 3
/*
 * Hipn - set highest referenceable parameter
 * takes:
 *	Player instance, parameter number.
 * returns: 
 *	former value
 * 	returns -1 if attempting to make it bigger.
 * side effects:
 *	Sets Player_stat to P_NULL_PTR if no Player instance data.
 * notes:
 *	if n < 0, just return former value, do not set
 */
E 3

Hipn(x, n)
D 3
	register Player *x;
	register int n;
E 3
I 3
	register Player *x;	/* Player instance pointer */
	register int	n;	/* index of new highest parameter */
/*
 * Set highest referenceable parameter in Player instance.
 * .LP
 * Returns 
 * previous value, or
 * \-1 if n is greater than previous value.
 * Sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP 'if x == NULL',
 * and returns \-1.
 * This is used to reduce the highest addressable \fBP\fP, \fBPs\fP, 
 * or \fBPp\fP, field
 * that will be printed when producing cmusic note-list output.
 * Also, \fBSet_P()\fP, etc., may no longer address them.
 * \fBP\fP-variables above this index continue to be accessable to the Player 
 * instance for which they are local.
 * Does not free any memory.
 * If 'n < 0', just return current value.
 */
E 3
{
	Player_stat &= ~P_NULL_PTR;
	if (x == NULL) {
		Player_stat |= P_NULL_PTR;
		return(-1);
	}
	if (n < 0)
D 2
		return(x->hipn);
	if (n <= x->hipn) {
E 2
I 2
		return(x->P_hipn);
	if (n <= x->P_hipn) {
E 2
		register int oldn;

D 2
		oldn = x->hipn;
		x->hipn = n;
E 2
I 2
		oldn = x->P_hipn;
		x->P_hipn = n;
E 2
		return(oldn);
	}
	return(-1);
}
E 1
