h47164
s 00008/00011/00030
d D 2.1 86/01/30 16:33:15 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00041/00000/00000
d D 1.1 85/11/05 16:45:18 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include <ctype.h>
#include <carl/defaults.h>

Function *Gen(cmd)
	register char *cmd;
/*
 * Get Function from pipe. 
D 2
 * .TP 10
 * Takes:
E 2
I 2
 * .LP
 * Takes
E 2
 * complete command string to pass to popen(2).
D 2
 * .TP 10
 * Returns:
 * NULL on errors otherwise, the desired Function.
 * .TP 10
 * Side effects:
 * Name field of function is set to the command that generated it.
 * .TP 10
 * Notes:
 * Default type is H_MONO_IN_X.
E 2
I 2
 * Typically used to synthesize functions with gen(1carl) commands.
 * Returns
 * 'NULL' on errors otherwise, the desired Function.
 * Name element of Function structure will 
 * contain the command that generated the Function.
 * Default type is 'H_MONO_IN_X'.
E 2
 */
{
	extern char		*strcpy();
	extern FILE 		*popen(); 
	extern Function		*getgenfunc();
	register FILE 		*pp;
	register Function 	*x; 

	if ((pp = popen(cmd, "r")) == NULL) {
		fprintf(stderr, "gen: popen failed on command:\n``%s''\n", cmd);
		return(NULL);
	}
	/* read function, coerce to be mono in x if no header */
	x = read_func_fid(pp, H_MONO_IN_X);
	if ((x->fname = (char *) malloc((unsigned) strlen(cmd)+1)) == NULL)
		malerr("Gen", 1);
	(void) strcpy(x->fname, cmd);
	return(x);
}
E 1
