/* ascii.h	2.1	(CARL)	10/26/85	23:49:48 */

/* character categories:
	a	#, $, @, `
	#	NL (newline)
	0	undefined (includes all ^ chrs not considered white space)
	l	[g-m,o-q,s,u-w,y-z,]
	h	[a,c,d]
	b	b
	e	e
	f	f
	x	x
	j	[n,r,t]
	.	.
	o	[1-7]	(all octal numbers)
	d	[8-9]	(remaining decimals)
	z	0
	w	sp, ht, vt, lf, cr
	q	"
	s	'
	+	+
	-	-
	r	%<=!&^|?:	(compound operators are only treated singly)
	/	/
	*	*
	>	>
	c	,
	y	\	
	;	;
	(){}[]	appear as themselves
*/

char ascii[] = 
{
/*  |000 nul|001 soh|002 stx|003 etx|004 eot|005 enq|006 ack|007 bel| */ 
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0', 

/*  |010 bs |011 ht |012 nl |013 vt |014 np |015 cr |016 so |017 si | */
	'\0',	'w',	'#',	'\0',	'\0',	'w',	'\0',	'\0',

/*  |020 dle|021 dc1|022 dc2|023 dc3|024 dc4|025 nak|026 syn|027 etb| */
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',

/*  |030 can|031 em |032 sub|033 esc|034 fs |035 gs |036 rs |037 us | */
	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',	'\0',

/*  |040 sp |041  ! |042  " |043  # |044  $ |045  % |046  & |047  ' | */
	'w',	'r',	'q',	'a',	'a',	'r',	'r',	's',

/*  |050  ( |051  ) |052  * |053  + |054  , |055  - |056  . |057  / | */
	'(',	')',	'*',	'+',	'c',	'-',	'.',	'/',

/*  |060  0 |061  1 |062  2 |063  3 |064  4 |065  5 |066  6 |067  7 | */
	'z',	'o',	'o',	'o',	'o',	'o',	'o',	'o',

/*  |070  8 |071  9 |072  : |073  ; |074  < |075  = |076  > |077  ? | */
	'd',	'd',	'r',	';',	'r',	'r',	'>',	'r',

/*  |100  @ |101  A |102  B |103  C |104  D |105  E |106  F |107  G | */
	'a',	'h',	'b',	'h',	'h',	'e',	'f',	'l',

/*  |110  H |111  I |112  J |113  K |114  L |115  M |116  N |117  O | */
	'l',	'l',	'l',	'l',	'l',	'l',	'j',	'l',

/*  |120  P |121  Q |122  R |123  S |124  T |125  U |126  V |127  W | */
	'l',	'l',	'j',	'l',	'j',	'l',	'l',	'l',

/*  |130  X |131  Y |132  Z |133  [ |134  \ |135  ] |136  ^ |137  _ | */
	'x',	'l',	'l',	'[',	'y',	']',	'r',	'l',

/*  |140  ` |141  a |142  b |143  c |144  d |145  e |146  f |147  g | */
	'a',	'h',	'b',	'h',	'h',	'e',	'f',	'l',

/*  |150  h |151  i |152  j |153  k |154  l |155  m |156  n |157  o | */
	'l',	'l',	'l',	'l',	'l',	'l',	'j',	'l',

/*  |160  p |161  q |162  r |163  s |164  t |165  u |166  v |167  w | */
	'l',	'l',	'j',	'l',	'j',	'l',	'l',	'l',

/*  |170  x |171  y |172  z |173  { |174  | |175  } |176  ~ |177 del| */
	'x',	'l',	'l',	'{',	'r',	'}',	'r',	'\0'
};

