/* %M%	%I%	(CARL)	%G%	%U% */
/*
 * sndout now takes optional -b and -e flags to
 * specify the limits of a rewrite. With these specified, the file to be
 * rewritten must exist, and the segment must start no farther down than the
 * last sample in the current file.  It will be expanded up to the limit of
 * the end of the last cylinder, if the file is realtime, or up to the limit
 * of the disk for non-realtime.
 */

#include <stdio.h>
#include <carl/sndio.h>
#include <carl/carl.h>
#include <carl/defaults.h>

#define TRUE 1
#define FALSE 0
#define IGNORE TRUE
#define DONT_IGNORE FALSE
#define min(a,b) ((a) < (b) ? (a) : (b))
#define SFMAXOPT 2

#define DEFINSIZ float		/* size of default input sample */
#define ALTINSIZ short
#define DEFINPAK 'f'
#define ALTINPAK 's'

char *dfltvals[] = DFLTVALS;

main(argc, argv)
	int argc; char **argv;
{
	extern long sndo();
	extern char *malloc();
	int usage();
	int (*getbuf)() = fgetfbuf;
	struct sndesc 
		*sfd,			/* holds info about sound file */
		*rdheader(),
		*sfoargs();		/* snarfs down command line arguments */
	short *buf;			/* input sample buffer */
	int rtnval;			/* flag returned from sndo */
	int ibps = sizeof(DEFINSIZ);/* size of what we expect to see on input */
	short spbuf = P_BUFSIZE / ibps;
	register long 
		st, 			/* starting sample frame */
		n; 
	char sfopt[2];		/* holds string passed to sndo */
	char ipak=DEFINPAK;		/* set default input packing */
	long start, end;

	sfopt[0] = ipak; sfopt[1] = NULL;

	sfsetiname(argv[0]);
	/* read command line args if any, and open file */
	if ((sfd = sfoargs(argc, argv, &ipak, &start, &end, DFLTARGS, 
		dfltvals, usage, DONT_IGNORE, TRUE)) == NULL)
			exit(1);
	if ((sfd = rdheader(sfd, &ipak, stdin)) == NULL)
		exit(1);
	if (wsdf((char *) NULL, sfd)) {	/* update the sdf */
		fprintf(stderr, "sndout: wsdf failed writing %s\n", sfd->sfn);
		goto out;
	}
	if (ipak == ALTINPAK) {
		   ibps = sizeof(ALTINSIZ); 
		   spbuf = P_BUFSIZE / ibps;
		   *sfopt = ALTINPAK;
		   getbuf = fgetsbuf;
       }

	buf = (short *) malloc(P_BUFSIZE); 

	for (st=start; (n = (*getbuf)(buf, spbuf, stdin)) > 0; st += n) {
		n = min(n, end - st);
		if ((rtnval = sndo(sfd, (char *) buf, st, n, sfopt)) <= 0)
			break;
	}
	if (n < 0) 
		fprintf(stderr,"sndout: read error\n");
	if (n > 0 && rtnval == 0)	/* we hit the end of file on writing */
		fprintf(stderr,"sndout: writing beyond last sample in file.\n");
out:	if (sclosesf(sfd)) {
		fprintf(stderr,"sndout: can't close file.\n");
		exit(1);
	}
	exit(0);
}


usage() 
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
"usage: sndout [flags] [sound_file] < floatsams\n",
" flags: flag = (value, value... : default)\n",
" b, e, d, = begin, end and duration,\n",
" c = chans(1,2,4:1),\n",
" R = sample Rate(",
DEFSR,
"),\n",
" i = input packing(s,f:f),\n",
" o = output packing(s,f:s),\n",
" T = file size(expressed as time in seconds),\n ",
" C = cyls(1),\n",
" t = realtime flag (r,n:r),\n",
" r = remark(NULL),\n",
" I = include(NULL),\n",
" p = protection(0644),\n",
" S = scratch,\n",
" H = hold\n"
);
}
