h08741
s 00000/00000/00097
d D 1.2 84/12/21 22:45:57 dgl 2 1
c added code to allow arbitrary properties to be stored in SDF files.
e
s 00097/00000/00000
d D 1.1 84/12/21 22:44:24 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <carl/defaults.h>
#include <carl/carl.h>
#include <carl/procom.h>

extern char sfoflags[];	/* from libsf/sfoargs.c */

CSNDFILE *
rdheader(sfd, ipak, iop)
	CSNDFILE *sfd;
	char *ipak;
	FILE *iop;
{
	extern struct csnd_prop *cop_prop();
	extern char *index();
	char *pval;

	if (*ipak == PM16BIT)
		set_sample_size(sizeof(short));

	if (getheader(iop) == NULL)
		return(sfd);

	if ((pval = getprop(iop, H_FORMAT)) != NULL) {
		if (!strcmp(pval, H_FLOATSAM))
			*ipak = PMFLOAT;
		else
			*ipak = PM16BIT;
	}
	if (index(sfoflags, FNC) == NULL) {	/* no -c flag? use header */ 
		if ((pval = getprop(iop, H_NCHANS)) != NULL)
			sfd = setsfd(sfd, "c", pval);
	}
	if (index(sfoflags, FSR) == NULL) {	/* no -R flag? use header */ 
		if ((pval = getprop(iop, H_SRATE)) != NULL)
			sfd = setsfd(sfd, "R", pval);
	}
	if (index(sfoflags, FPM) == NULL) {	/* no -P flag? use header */ 
		if ((pval = getprop(iop, H_SNDOUT_FORMAT)) != NULL) {
			if (!strcmp(pval, H_FLOATSAM))
				sfd = setsfd(sfd, "P", "f");
			else
				sfd = setsfd(sfd, "P", "s");
		}
	}
	while ((pval = getprop(iop, H_REMARK)) != NULL) {
		sfd = setsfd(sfd, "r", pval);
		if (rmprop(iop, H_REMARK) != 0)
			break;
	}
	/* flush pre-digested properties */
	(void) rmprop(iop, H_HEAD); 
	(void) rmprop(iop, H_FORMAT); 
	(void) rmprop(iop, H_NCHANS);
	(void) rmprop(iop, H_SRATE);
	(void) rmprop(iop, H_SNDOUT_FORMAT);
	(void) rmprop(iop, H_TAIL);
	/* pick up any remarks from the header */
	/* sequester the rest of undigested properties */
	sfd->csnd_p = cop_prop(iop);

	return(sfd);
}

struct csnd_prop *cop_prop(iop)
	FILE *iop;
{
	extern char *malloc();
	char *pname, *pval;
	struct csnd_prop *cprop = NULL, *chead = NULL, *clast = NULL;
	PROP *hprop;
	extern PROP *getplist();

	for (hprop = getplist(iop); hprop != NULL; hprop = hprop->nextprop) {
		if ((cprop = (struct csnd_prop *) 
		    malloc(sizeof(struct csnd_prop))) == NULL)
			malerr("malloc", 1);
		if (chead == NULL)
			chead = cprop;
		if (clast != NULL)
			clast->cprop_next = cprop;
		if ((cprop->cprop_name = malloc(strlen(hprop->propname)+1)) 
		    == NULL)
			malerr("cop_prop", 1);
		strcpy(cprop->cprop_name, hprop->propname);
		if ((cprop->cprop_val = malloc(strlen(hprop->propval)+1))
		    == NULL)
			malerr("cop_prop", 1);
		strcpy(cprop->cprop_val, hprop->propval);
		clast = cprop;
	}
	if (cprop != NULL)
		cprop->cprop_next = (struct csnd_prop *) NULL;
	return(chead);
}
E 1
