/* sfnorm.c	1.3	(CARL)	9/5/84	16:19:29 */
#include <stdio.h>
#include <carl/carl.h>
#include <carl/sndio.h>
#include <math.h>

extern int sferror;
extern CSNDFILE *rootsfd, *opensf();
/* these two from crack.c */
extern int arg_index;
extern char *arg_option;
extern float sfexpr(), fsndi();

main(argc, argv)
	char **argv;
{
	CSNDFILE *sfd;
	int otty = isatty(1);
	long i;
	float output; 	/* output can't be register variable */
	float max = -HUGE, amax = 1.; 
	long end = 0, begin = 0; 
	char *cbeg = NULL, *cend = NULL, *cdur = NULL, *file = "test", ch;

	/* get arguments */
	while ((ch = crack(argc, argv, "a|b|e|d|h", 1)) != NULL) {
		switch (ch) {
			case 'a': amax = sfexpr(arg_option, 1.0); break;
			case 'b': cbeg = arg_option; break;
			case 'e': cend = arg_option; break;
			case 'd': cdur = arg_option; break;
			case 'h': usage(0); break;
			default:  usage(1);
		}
	}
	if (arg_index < argc) 
		file = argv[arg_index];

	/* open sound file */
	if ((sfd = opensf(file, "-r")) == NULL) { 
		fprintf(stderr, "opensf failed on %s\n", file);
		(void) sfallclose(); 
		exit(1); 
	}

	/* calculate times */
	if (cbeg != NULL) 
		begin = sfexpr(cbeg, sfd->sr)*sfd->nc;
	if (cend != NULL)
		end = sfexpr(cend, sfd->sr)*sfd->nc;
	else if (cdur != NULL)
		end = sfexpr(cdur, sfd->sr)*sfd->nc + begin;

	/* check boundaries */
	if (begin < 0 || begin >= sfd->fs) {
		fprintf(stderr, "begin time out of range\n");
		quit();
	}
	if (end < 0 || end >= sfd->fs) {
		fprintf(stderr, "end time out of range\n");
		quit();
	}
	if (end == 0)
		end = sfd->fs;

	/* calculate normalization factor */
		for (i = begin; i < end; i++) {
			output = fsndi(sfd, i);
			if (sferror) 
				quit();
			if (output < 0.0)
				output = -output;
			if (output > max)
				max = output;
		}

	/* is  max legal? */
	if (max == 0.0){
		fprintf(stderr,"sfnorm: input is all zero!\n");
		quit();
	}
	else
		max = amax / max;

	/* output the procom header */
	if (! otty)
		if (mkstdheader(stdout, sfd) != 0)
			exit(1);

	/* normalize and output samples */
	for (i = begin; i < end; i++) {
		output = fsndi(sfd, i) * max;
		if (sferror) 
			quit();
		if (otty) 
			printf("%d\t%f\n", i, output);
		else 
			putfloat(&output);
	}

	/* force out buffered samples */
	if (!otty) 
		flushfloat();

	/* close all open files */
	(void) sfallclose();
	exit(0);
}

mkstdheader(iop, sfd)
	FILE		*iop;
	CSNDFILE	*sfd;
{
	char		srate[BUFSIZ];
	char		nchans[BUFSIZ];

	(void) sprintf(srate, "%g", sfd->sr);
	(void) sprintf(nchans, "%d", sfd->nc);

	if (stdheader(iop, sfd->sfn, srate, nchans, H_FLOATSAM)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}

# ifdef notdef
	if (putheader(iop)) {
		fprintf(stderr, "stdheader failed\n");
		return(-1);
	}
# endif

	return(0);
}

quit() {
	fprintf(stderr, "exiting\n");
	(void) sfallclose(); 
	exit(1); 
}

usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s",
"usage: sfnorm [flags] csound_file > floatsams\n",
" sfnorm writes amplitude-normalized floatsams on standard output\n",
" flags:\n",
" -aN  normalize to amplitude N\n",
" -bN  begin at time N\n",
" -eN  end at time N\n",
" -dN  duration is time N\n"
);
exit(ex);
}
