/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

main(argc, argv)
	char **argv;
{
    char *ctime();
    FILE *fp, *fopen();
    char buf[BUFSIZ], *fil, *getsfile(), *timestr, *c, *rindex();
    int dumplevel, dumpdate, tapeid, tpmax = 0;

    if (argc < 2) {
	fprintf(stderr, "usage: sfdt csound_filesystem\n");
	exit(1);
    }
    setsfile(argv[1]);
    fil = getsfile(SFINCREM);
    if (!access(fil, 0))	/* file is there */
	{
	fp = fopen(fil, "r");
	if (fp == NULL)
	    {
	    fprintf(stderr, "sfdt: no dump record file: %s\n", fil); 
	    exit(1);
	    }
	printf("%s\t%-24s\t%s\n", "level", "date", "tape id");
	while (fgets(buf, BUFSIZ, fp))
	    {
	    (void) sscanf(buf, "%d%D%d", &dumplevel, &dumpdate, &tapeid);
	    if (tapeid > tpmax) tpmax = tapeid;
	    timestr = ctime(&dumpdate);
	    c = rindex(timestr, '\n');
	    if (c != NULL) *c = '\0';
	    printf("%d\t%s\t%d\n", dumplevel, timestr, tapeid);
	    }
	if (fclose(fp) < 0)
		perror("fclose");
	}
}
