h24577
s 00123/00000/00000
d D 1.1 84/07/25 14:29:42 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

#define ALL (1 << 0)	/* from libsf/diread.c */
#define EXACT 2
#define PARTIAL 4
#define ONEDIR 8
extern char **difiles;
extern int difilcnt;
extern int emptdir;

char *defname=SDFSFN, *path;
extern int arg_index;
extern char *arg_option;

main(argc, argv)
    	int argc; char *argv[];
{
    int delerr=0, n;
    int err = 0, dirflg = 0, test=0, i;
    char *getsfile(), ch, crack();
    int diread();
    struct sfstab *dirinfo(), *sfs;

    while ((ch = crack(argc, argv, "rth", 0)) != NULL) {
	switch (ch) {
	    case 'r':
		dirflg++;
		break;
	    case 't':
		test++;
		break;
	    case 'h':
		fprintf(stderr, "usage: rmsf [-r -t] filenames\n");
		exit(0);
	    default:
		fprintf(stderr, "usage: rmsf [-r -t] filenames\n");
		exit(1);
	}
    }

    if (arg_index == argc) {	/* delete file test by default */
	argv[arg_index] = defname+1; 	/* sidestep the initial '/' */
	argc++;
    }

    while (argc > arg_index) {
	if ((sftype(argv[arg_index])) > SFILE) {	
	    /* request to delete an entire directory */
	    char cmd[128], *getsfn(), *getprown();
	    extern char *index();

	    /* make sure user wants to by requiring -r flag too */
	    if (!dirflg) {
		fprintf(stderr, "rmsf: use -r flag to delete directories.\n");
		exit(1);
	    }
	    /* check path for permission */
	    path = getsfn(argv[arg_index], 0);	/* mallocs its return arg */
	    if (ownspath(path, getprown()) < 0) {
		fprintf(stderr, 
		    "rmsf: no permission to delete directory: %s\n", path);
		err++;
		arg_index++;
		continue;
	    }
	    if ((sfs = dirinfo(path)) == NULL) {
		fprintf(stderr, "rmsf: dirinfo failed\n");
		exit(1);
	    }
	    if (index(sfs->devmode, 'x')) {	/* offline? */
		fprintf(stderr, "rmsf: %s disabled\n", sfs->sdfdir);
		err++;
		arg_index++;
		continue;
	    }
	    /* figure out what to delete */
	    if (diread(path, NULL, ALL) != 1) {
		fprintf(stderr, "rmsf: diread failed\n");
		exit(1);
	    }
	    /* now do the deletions */
	    for (i = 0; i < difilcnt; i++) {	/* difilcnt set by diread */
		if (test) 
			printf("%s\n", difiles[i]);
		else if ((n = unlinksf(difiles[i])) != 0) {
		    delerr++;
		    if (n < 0) {	/* quit on hard errors */
			exit(++err);
		    }			/* soft errors are continuable */
		}
	    }
	    if (!test && !delerr) {
		int rtn;

		(void) sprintf(cmd, "rm -rf %s\n", path);
		(void)setuid(geteuid());	/* make us really be disk */
		if ((rtn = system(cmd))) {
		    perror("system");
		    fprintf(stderr,"rmsf: error removing directory %s %d\n",
			    path, rtn);
		    err++;
		}
	    } else
		err++;
	    free(path);
	} else {	/* argument is just one file */
	    if (test) 
		printf("%s\n", argv[arg_index]);
	    else {
		if ((n = unlinksf(argv[arg_index])) != 0) {
		    if (n < 0) {
			exit(++err);
		    }
		    err++;
		}
	    }
	}
	arg_index++;
    }
    exit(err);
}
E 1
