/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <sys/time.h>
#include <carl/libsf.h>

/*
 * plentry - print long form file directory entry from a sfentry structure.
 * If dmpfmt is true, print a form useful for viewing dump directories.
 */


plentry(sfe, dmpfmt, stripd)
	struct sfentry *sfe;
	int dmpfmt, stripd;
{
    extern char *rindex(), *strcpy();
    static first;
    char *ctime(), *timestr, timebuf[32], *i, *index(), *c, *d,
	*inprog="in progress";
    if (sfe == NULL) return;
    if (!first)
	{
	first++;
	if (dmpfmt)
	    printf("%-20s%4s%5s%3s%8s%5s %-3s %-26s\n", "name", "levl", 
		"tid", "sq", "own", "siz", "rt", "dumped");
	else
	    printf("%-20s%4s%5s%3s%8s%5s %-3s %-26s\n", "name", "stat", "pro",
		"ln", "own", "siz", "rt", "modified");
	}

    if (sfe->status & SFWRITE)	/* file is being written */
	strcpy(timebuf, inprog);
    else
	{
	timestr = ctime((unsigned long)
		(!dmpfmt) ? &sfe->modate : &sfe->dumpdate);
	strcpy(timebuf, timestr);
	i = index(timebuf, '\n');
	*i = NULL;
	}

    /* strip device */
    if (stripd)
	c = index(sfe->nsdf+1, '/');
    else
	c = sfe->nsdf;

    /* strip suffix */
    d = (char *) rindex(c, '.');		
    if (d != NULL) *d = NULL;
	
    if (dmpfmt)
	printf("%-20s%4d%5d%3d%8s%5d%3c %-26s\n", c, 
	    QDUMPLEVEL(sfe->tapekey), QTAPEID(sfe->tapekey), 
	    QTAPESEQ(sfe->tapekey), sfe->owner, sfe->size, sfe->rt, timebuf);
    else
	printf("%-20s%4d%5o%3d%8s%5d%3c %-26s\n",
	    c, sfe->status, sfe->prot, sfe->links, sfe->owner,
	    sfe->size, sfe->rt, timebuf);
    }
