/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>
#include <ctype.h>

int test = 0, do_it = 0;

main(argc, argv)
	char **argv;
{
	extern CSNDFILE *accesf();
	char *filsys, level = 0, ch;
	struct sfstab *sfs, *dirinfo();
	long maxlen, cyls = 0, Scyls = 0, Hcyls = 0, sum = 0;
	extern long getfiles();

	while ((ch = crack(argc, argv, "C|S|H|thy", 0)) != NULL) {
		switch (ch) {
			case 'C': 
				cyls = sfexpr(arg_option, 1.0); 
				level = 0;
				break;
			case 'S': 
			case 'H': 
				cyls = sfexpr(arg_option, 1.0); 
				level = ch;
				break;
			case 't':
				test = 1;
				break;
			case 'y':
				do_it = 1;
				break;
			case 'h':
			default:  
				usage(1);
		}
	}

	/* reaping only hold files requres permission */
	if (level == 'H' || do_it && ingroup(SUPERGROUP) != 1) {
		fprintf(stderr, 
			"reapsf: -H and -y flags reserved for wizards\n");
		usage(1);
	}

	/* pick up filesystem to reap */
	if (arg_index < argc)
		filsys = argv[arg_index];
	else
		usage(1);

	/* range checking */
	if ((sfs = dirinfo(filsys)) == NULL) {
		fprintf(stderr, "reapsf: dirinfo failed on %s\n", filsys);
		exit(1);
	}
	maxlen = sfs->devlen;
	if (cyls == 0)
		cyls = maxlen;
	if (cyls > maxlen) {
		fprintf(stderr, 
		    "reapsf: request=%D larger than filesystem total=%D\n",
		    cyls, maxlen);
		fprintf(stderr, "reapsf: truncating request\n");
		cyls = maxlen;
	}

	/* select files to reap */
	switch (level) {
	  case 0:
	    if ((Scyls = getfiles(filsys, 'S', cyls)) < cyls) {
		printf("reapsf: will reap %D scratch cylinders\n", Scyls);
		if (yes("Reap hold files for remainder?", do_it))
		    Hcyls = getfiles(filsys, 'H', cyls - Scyls);
		else
		    fprintf(stderr, "reapsf: ok, only reaping scratch files\n");
		if ((sum = Scyls + Hcyls) < cyls)
		    fprintf(stderr, "reapsf: found %D cylinders to reap\n",
			    sum);
	    } else
		    sum = cyls;
	    break;
	  case 'S':
	    /* fall through */
	  case 'H':
	    if ((sum = getfiles(filsys, level, cyls)) < cyls)
		printf("reapsf: will reap %D cylinders\n", sum);
	    break;
	}

	delete(sum);
	printf("reapsf: total reclaimed: %D\n", sum);
	exit(0);
}

char **filary;
long filcnt;

delete(cyls)
	long cyls;
{
	long i, j;
	CSNDFILE *sfd;

	if (cyls == 0)
		return;

	for (i = j = 0; i < filcnt && j < cyls; i++, j += sfd->ncyls) {
		if ((sfd = accesf(filary[i])) == NULL) {
			fprintf(stderr, "reapsf: accesf failed on%s\n", 
				filary[i]);
			exit(1);
		}
		if (j < cyls) {
			if (test != 0) {
				fprintf(stderr, "would delete: %s\n", 
					filary[i]);
				continue;
			}
			if (delsf(sfd->sfn, 0) != 0) {
				fprintf(stderr, "reapsf: can't delete %s\n", 
					filary[i]);
				exit(1);
			}
		}
	}
}

long
getfiles(filesys, level, amt)
	char *filesys, level;
	long amt;
{
	extern char *strcat(), *strcpy();
	FILE *pp, *popen();
	char tmp[BUFSIZ], *c;
	long ncyls, total = 0;

	/* either "purgesf -L -D -S /snd", or "purgesf -L -D -H /snd" */
	(void) strcpy(tmp, "purgesf -L -D -");
	(void) strcat(tmp, level==SCRAT ? "S " : "H ");
	(void) strcat(tmp, filesys);
	if ((pp = popen(tmp, "r")) == NULL) {
		fprintf(stderr, "reapsf: popen failed: %s\n", tmp); 
		exit(1);
	}
	while (fgets(tmp, BUFSIZ, pp) != NULL) {
		for (c = tmp; !isspace(*c) && *c != '\0'; c++)
			/* empty */ ;
		if (c != NULL) 
			*c = NULL;
		filcnt = strsav(&filary, tmp);
		if (c != NULL) 
			*c = '\t';
		(void) sscanf(tmp, "%*s%D%*s", &ncyls);
		if ((total += ncyls) >= amt)
			return(total);
	}
	return(total);
}

usage(ex)
{

switch (ex) 
{

case 1:
fprintf(stderr, "%s%s%s%s%s%s%s",
"usage: reapsf [flags] file_system\n",
" flags:\n",
" -CN specify N cylinders to be reaped, first from Scratch then Hold files\n",
" -SN specify N scratch cylinders to be reaped\n",
" -HN specify N hold cylinders to be reaped (wizard only)\n",
" -t  test - only print files that would be affected, do not delete\n",
" -y  answer yes to all questions (wizard only)\n"
);
break;

case 2:
fprintf(stderr, "%s",
" reapsf: -t flag must be used with one of -SN or -HN\n"
);
break;
}

exit(ex);
}
