h36026
s 00065/00046/00188
d D 1.2 84/08/19 00:00:56 disk 2 1
c changed purgesf such that supplying neither -H nor -S 
c would cause it to print first scratch files, then hold files, rather
e
s 00234/00000/00000
d D 1.1 84/07/25 14:28:38 disk 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */
#include <stdio.h>
#include <carl/libsf.h>

/* diread() uses these */
#define DI_ALL 1
#define DI_EXACT 2
#define DI_PARTIAL 4
#define DI_ONEDIR 8

#define DEFCUTOFF 14

/* diread builds string array on these */
extern char **difiles;
extern int difilcnt;
extern int emptdir;


char n1[] = "The following sound files have been unreferenced since:";
char n2[] = "and are therefor subject to purging.";
char d1[] = "The purge is scheduled for:";

D 2
int bug;

E 2
main(argc, argv)
	char **argv;
{
	extern char *ctime();
	extern long atol();
	CSNDFILE *accesf(), *sfd;
	int 	i, 
		lf=0, 		/* long format */
		notify=0, 	/* notify format */
D 2
		ulist=0, 	/* list of users affected */
E 2
I 2
		Ulist=0, 	/* list of users affected */
E 2
		date=0,		/* sort by date rather than path */
D 2
		flag=0,
E 2
I 2
		flag=0,		/* S or H for Scratch or Hold files */
		tflag,
		cnt,
E 2
		pcylcnt=0;	/* just print date */
	long cutoff=0, then(), pdate=0;
	long cylcnt = 0;
	char *filsys,  ch;

D 2
	while ((ch = crack(argc, argv, "lLt|Nnd|uDSHhb|", 0)) != NULL) {
E 2
I 2
	while ((ch = crack(argc, argv, "lLt|Nnd|uDSHh", 0)) != NULL) {
E 2
		switch (ch) {
			case 'l': lf=1; break;
			case 'L': lf=2; break;
			case 'N': lf=1; notify++; break;
			case 'n': pcylcnt++; break;
			case 'd': 
				lf=1; 
				pdate = then(-atol(arg_option)); 
				break;
D 2
			case 'u': ulist++; break;
E 2
I 2
			case 'u': Ulist++; break;
E 2
			case 't': cutoff = then(atol(arg_option)); break;
			case 'D': date++; break;
			case 'S': /* drops through */
			case 'H': flag = ch; break;
D 2
			case 'b': bug = atol(arg_option); break;
E 2
			case 'h': /* drops through */
			default:  usage(1);
		}
	}

	if (cutoff == 0) {
		if (flag == 'S')
			cutoff = then(NSCRAT);
		else if (flag == 'H')
			cutoff = then(NHOLD);
		else
			cutoff = then(DEFCUTOFF);
	}

D 2
	if (bug)
		printf("cutoff: %s", ctime(&cutoff));

E 2
	if (arg_index < argc)
		filsys = argv[arg_index];
	else
		usage(1);

	if (notify) {
		printf("%s\n", n1);
		printf("%s", ctime(&cutoff));
		printf("%s\n\n", n2);
	}
	if (pdate) {
		printf("%s\n", d1);
		printf("%s\n\n", ctime(&pdate));
	}

	(void) diread(filsys, (char *) NULL, DI_ALL);
D 2
	for (i = 0; i < difilcnt; i++) {
	    if (is_sfn(difiles[i])) {
		if ((sfd = accesf(difiles[i])) != NULL) {
		    if (bug == 2) printf("file: %-32s sc: %c rdate: %s", 
			sfd->sfn, sfd->fhold, ctime(&sfd->rdate));
		    if ((flag==0 && sfd->rdate < cutoff) ||
				((flag==SCRAT && sfd->fhold==SCRAT ||
				flag==SHOLD && sfd->fhold==SHOLD) && 
				sfd->rdate<cutoff)) {
			    if (!ulist)
				addlnk(sfd, date);
			    alist(difiles[i]);
			    cylcnt += sfd->ncyls;
			    if (bug == 2) printf("!\n");
E 2
I 2
	
	if (flag == 0)
		cnt = 2;
	else
		cnt = 1;
	for ( ; cnt > 0; cnt--) {
	    if (flag == 0) {
		if (cnt == 2) {
			tflag = SCRAT;
			cutoff = then(NSCRAT);
		} else {
			tflag = SHOLD;
			cutoff = then(NHOLD);
		}
	    } else
		tflag = flag;
	    for (i = 0; i < difilcnt; i++) {
		if (is_sfn(difiles[i])) {
		    if ((sfd = accesf(difiles[i])) != NULL) {
			putdot();
			if ((tflag==0 && sfd->rdate < cutoff) ||
				    ((tflag==SCRAT && sfd->fhold==SCRAT ||
				    tflag==SHOLD && sfd->fhold==SHOLD) && 
				    sfd->rdate<cutoff)) {
				if (!Ulist)
				    addlnk(sfd, date);
				alist(difiles[i]);
				cylcnt += sfd->ncyls;
			}
E 2
		    }
		}
	    }
	}
I 2

E 2
	if (!pcylcnt)
		prtPurgFiles(lf);
D 2
	if (((lf == 1) && !ulist) || pcylcnt)
E 2
I 2
	if (((lf == 1) && !Ulist) || pcylcnt)
E 2
		printf("cylinders reclamable=\t%d\n", cylcnt);
D 2
	if (ulist)
		pulist();
E 2
I 2
	if (Ulist)
		pUlist();
E 2
	exit(0);
}

CSNDFILE *list;

prtPurgFiles(lf) 
{
	CSNDFILE *s;

	for (s = list; s != NULL; s = s->nxtsdf) {
		if (lf)
D 2
		    printf("%-32s\t%3d\t%s", s->sfn, s->ncyls, 
			ctime(&s->rdate));
E 2
I 2
		    printf("%-47s%3d %c %s", s->sfn, s->ncyls, 
			s->fhold, ctime(&s->rdate));
E 2
		else
		    printf("%s\n", s->sfn);
	}
}

addlnk(sfd, dfmt)
	CSNDFILE *sfd;
	int dfmt;
{
	CSNDFILE *s;

	if (list == NULL) {
		list = sfd;
		list->nxtsdf = list->lstsdf = NULL;
	} else {
		if (dfmt) {
			for (s = list; s != NULL; s = s->nxtsdf) {
				if (s->nxtsdf == NULL) {
					s->nxtsdf = sfd;
					sfd->lstsdf = s;
					break;
				}
				if (sfd->rdate < s->rdate) {
					if (s->lstsdf != NULL)
						s->lstsdf->nxtsdf = sfd;
					sfd->lstsdf = s->lstsdf;
					s->lstsdf = sfd;
					sfd->nxtsdf = s;
					if (s == list) list = sfd;
					break;
				}
			}
		} else {
			for (s = list; s != NULL; s = s->nxtsdf) {
				if (s->nxtsdf == NULL) {
					s->nxtsdf = sfd;
					sfd->lstsdf = s;
					break;
				}
			}
		}
	}
}
D 2
	
E 2

I 2
char *dot;

E 2
is_sfn(name)
	char *name;
{
D 2
	char *index(), *rindex(), *c;
E 2
I 2
	char *index(), *rindex();
E 2

D 2
	c = rindex(name, '.');
	if (c == NULL)
E 2
I 2
	dot = rindex(name, '.');
	if (dot == NULL)
E 2
		return(0);
D 2
	else if (!strcmp(c, SDFEXT)) {
		*c = NULL;	/* terminate it */
E 2
I 2
	else if (!strcmp(dot, SDFEXT)) {
		*dot = '\0';
E 2
		return(1);
	}
	return(0);
}

I 2
putdot()
{
	*dot = '.';
}
	

E 2
usage(ex)
{
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s%s%s",
D 2
"usage: purgesf [flags] filesys\n",
E 2
I 2
"usage: purgesf [flags] directory\n",
E 2
" flags:\n",
D 2
" -tN list files unreferenced for more than N hours\n",
" -N  use \"notify\" format\n",
" -dN day N (N == # days in future) included in purge note with -N\n",
" -n  just print number of cylinders available\n",
E 2
I 2
" -S  lists scratch files that can be deleted\n",
" -H  lists hold files that can be deleted\n",
"     if neither -S nor -H is given, list both\n",
E 2
" -l  long form listing\n",
D 2
" -D  sort by referenced date, oldest first\n",
" -u  list users affected by purge\n",
" -S  list only scratch files\n",
" -H  list only hold files\n",
" no flags: just print filenames\n"
E 2
I 2
" -D  sorts by referenced date, oldest first\n",
" -tN lists files unreferenced for more than N hours\n",
" -n  only prints number of cylinders reclaimable\n",
" -U  lists users affected by purge\n",
" -N  uses \"notify\" format\n",
" -dN day N (N == # days in future) included in purge note with -N\n"
E 2
);
exit(ex);
}

char *affected[1024];
int affcnt;

alist(fname)
	char *fname;
{
	char *index(), *own, *c;
	int i, hit;

	own = index(fname+1, '/')+1;	/* isolate owner part */
	c = index(own, '/');
	if (c != NULL) 
		*c = NULL;
	for (i = hit = 0; i < affcnt; i++) {
		if (!strcmp(affected[i], own))
			hit++;
	}
	if (!hit)
		affected[affcnt++] = own;
}

D 2
pulist()
E 2
I 2
pUlist()
E 2
{
	int i;

	for (i = 0; i < affcnt; i++) 
		printf("%s\n", affected[i]);
}
E 1
