#include <stdio.h>
#include <carl/carl.h>
#include <carl/sndio.h>
#include <math.h>

extern int sferror;
extern CSNDFILE *rootsfd, *opensf();
/* these two from crack.c */
extern int arg_index;
extern char *arg_option;
extern float sfexpr(), fsndi();

main(argc, argv)
	char **argv;
{
	extern char *index();
	CSNDFILE *sfd;
	int otty = isatty(1);
	long i;
	float output; 	/* output can't be register variable */
	long begin, end, samp;
	char *cbeg = NULL, *cend = NULL, *file = "test", ch;
	char R[80];

	if (!otty)
		usage(1);

	/* get arguments */
	while ((ch = crack(argc, argv, "b|e|h", 1)) != NULL) {
		switch (ch) {
			case 'b': cbeg = arg_option; break;
			case 'e': cend = arg_option; break;
			case 'h': usage(0); break;
			default:  usage(1);
		}
	}
	if (arg_index < argc) 
		file = argv[arg_index];

	/* open sound file */
	if ((sfd = sopensf(file, "rw", (CSNDFILE *) 0)) == NULL) { 
		fprintf(stderr, "opensf failed on %s\n", file);
		(void) sfallclose(); 
		exit(1); 
	}

	/* calculate times */
	if (cbeg != NULL) 
		begin = sfexpr(cbeg, sfd->sr)*sfd->nc;
	if (cend != NULL)
		end = sfexpr(cend, sfd->sr)*sfd->nc;

	/* check boundaries */
	if (begin < 0 || begin >= sfd->fs) {
		fprintf(stderr, "begin time out of range\n");
		quit();
	}
	if (end < 0 || end >= sfd->fs) {
		fprintf(stderr, "end time out of range\n");
		quit();
	}
	if (end == 0)
		end = sfd->fs;

	printf("* ");
	fflush(stdout);
	while (gets(R) != NULL) {
		register char *x;
		if (*R != '=' && *R != 'e' && *R != 'b' && (x = index(R, '='))) {
			double S;
			*x = '\0';
			samp = sfexpr(R, 1.0);
			S = sfexpr(x+1, 1.0);
			sndo(sfd, &S, samp, (long) 1, "f");
			flushsf(sfd);
			printf("%d\t%f\n", samp, fsndi(sfd, samp));
		} else {
			switch (*R) {
			case 'g':
				glitch(sfd, begin, end + begin);
				break;
			case 'h':
				help();
				break;
			case 'i':
			    {
				float	sm1 = fsndi(sfd, samp-1), 
					sp1 = fsndi(sfd, samp+1); 
				float	S = ((sm1 - sp1) / 2.0) + sp1;
				sndo(sfd, &S, samp, (long) 1, "f");
				flushsf(sfd);
				printf("%d\t%f\n", samp, fsndi(sfd, samp));
				break;
			    }
			case 'p':
			    {
				/* output window */
				for (i = begin; i < end; i++) {
					if (i < 0 || i >= sfd->fs) {
						fprintf(stderr, "sample index out of range:%d\n", i);
						break;
					}
					output = fsndi(sfd, i);
					if (sferror) 
						quit();
					printf("%d\t%f\n", i, output);
				}
				break;
			    }
			case '-':
			case '+':
			    {
				register long delta = sfexpr(R, 1.0);
				if (   begin + delta < 0
				    || begin + delta >= sfd->fs
				    || end + delta < 0
				    || end + delta >= sfd->fs) {
					fprintf(stderr, "sample index out of range\n");
					break;
				}
				begin += delta;
				end += delta;
				break;
			    }
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			    {
				samp = sfexpr(R, 1.0);
				if (samp < 0 || samp >= sfd->fs) {
					fprintf(stderr, "sample index out of range:%d\n", samp);
					break;
				}
				printf("%d\t%f\n", samp, fsndi(sfd, samp));
				break;
			    }
			case 'e':
			    {
				register tmp;
				if (*(R+1) == '<')
					tmp = end - sfexpr(R+2, 1.0);
				else if (*(R+1) == '>')
					tmp = end + sfexpr(R+2, 1.0);
				else if (*(R+1) == '=')
					tmp = sfexpr(R+2, 1.0);
				else
					tmp = sfexpr(R+1, 1.0);
				if (tmp < 0 || tmp >= sfd->fs) {
					fprintf(stderr, "sample index out of range:%d\n", tmp);
					break;
				}
				end = tmp;
				break;
			    }
			case 'b':
			    {
				register tmp;
				if (*(R+1) == '<')
					tmp = begin - sfexpr(R+2, 1.0);
				else if (*(R+1) == '>')
					tmp = begin + sfexpr(R+2, 1.0);
				else if (*(R+1) == '=')
					tmp = sfexpr(R+2, 1.0);
				else
					tmp = sfexpr(R+1, 1.0);
				if (tmp < 0 || tmp >= sfd->fs) {
					fprintf(stderr, "sample index out of range:%d\n", tmp);
					break;
				}
				begin = tmp;
				break;
			    }
			case 'q':
			case 'Q':
				goto out;
			case 'x':
				goto out1;
			case '=':
			    {
				double S = sfexpr(R+1, 1.0);
				sndo(sfd, &S, samp, (long) 1, "f");
				flushsf(sfd);
				printf("%d\t%f\n", samp, fsndi(sfd, samp));
				break;
			    }
			default:
				fprintf(stderr, "not recognized.\n");
			}
		printf("* ");
		fflush(stdout);
		}
	}

	/* close all open files */
out:	sclosesf(sfd);
out1:	exit(0);
}

quit() {
	fprintf(stderr, "exiting\n");
	(void) sfallclose(); 
	exit(1); 
}

usage(x) 
{
fprintf(stderr, 
"usage: pokesf [flags] soundfile\
flags:\
-bN	begin at time N,\
-eN	end at time N\n");
	exit(x);
}
