/* shellcmd.c	1.2	(CARL)	8/10/84	12:11:35 */
#include <stdio.h>
#include <ctype.h>
#include <carl/sndio.h>
#include "play.h"

extern char shellstr[];	/* from interact.c */

shellcmd(fil, begin, end)
	int fil; long begin, end;
{
	long int i;
	CSNDFILE *sfd;
	float sample;
	FILE *pp, *popen();

	if (shellstr[0] == '\0') {
		fprintf(stderr, "shellcmd: no command!\n");
		return(-1);
	}

	pp = popen(shellstr, "w");
	if (pp == NULL) {
		perror("popen");
		return(-1);
	}

	sfd = pf[fil].sfp;

	for (i = begin; i < end; i++) {
		register int n;
		sample = fsndi(sfd, i);
		if ((n = pputfloat(pp, &sample)) != sizeof(float)) {
			fprintf(stderr, "pputfloat returned %d\n", n);
			pclose(pp);
			return(-1);
		}
	}

	pflushfloat(pp);
	pclose(pp);
	return(0);
}
