/* %M%	%I%	(CARL)	%G%	%U% */
# include <sys/types.h>
#define new
# include <vaxuba/dsc.h>
# include <stdio.h>
# include <carl/sndio.h>
/* theoretical max # of convs */
# define NDSSEQ 16
/* for multi-dma configurations */
# define DMA0 0
# define DMA1 1

extern int verbose;

setdsseq(fid, seq, dma)
	int fid; short *seq; int dma;
{
	register int i;
	struct ds_seq dsseq;

	if (verbose) printf("DSSEQ=");
	for (i = 0; seq[i] != -1 && i < NDSSEQ; i++)
		{
		dsseq.conv = seq[i];
		if (verbose) printf("\t%O", dsseq.conv);
		dsseq.conv |= (dma == DMA0) ? 0 : 020;
		if (verbose) printf("+DMA%c", dsseq.conv & 020 ? '1' : '0');
		dsseq.dirt = seq[i] < 010 ? AD : DA;
		if (verbose) printf("%s", dsseq.conv < 010 ? "+AD" : "+DA");
		dsseq.reg  = i;
		if (ioctl(fid, DSSEQ, &dsseq) == -1)
			{ perror("dsseq"); return(-1); }
		}
	if (i = 0) 
		{ 
		fprintf(stderr, "setdsseq: No DACs specified!\n"); 
		return(-1); 
		}
	if (verbose) printf("+LAST\n");
	if (ioctl(fid, DSLAST, &dsseq))
		{ perror("dslast"); return(-1); }
	return(0);
	}
