/* %M%	%I%	(CARL)	%G%	%U% */
# include <utmp.h>
# include <stdio.h>

static
char *
strsave(str)
	char	*str;
{
	extern	char *strcpy();
	extern	char *malloc();
	register char *cp;

	if ((cp = malloc((unsigned) strlen(str)+1)) == NULL)
		return(NULL);

	strcpy(cp, str);

	return(cp);
}

char *
getplace() {
	extern	char *strsave();
	extern	char *rindex();
	extern	char *ttyname();
	extern  char *malloc();
	struct	utmp ut;
	char	*tn, *tty;
	FILE	*fd;

	if ((tn = ttyname(fileno(stderr))) == NULL)
		return(NULL);

	if ((tty = rindex(tn, '/')) == NULL)
		return(NULL);

	tty++;	/* bump over '/' */

	/*
	 * check for network connection
	 */
	if (tty[3] == 'p') {
		if ((fd = fopen("/etc/utmp", "r")) == NULL)
			return(NULL);
		while (fread((char *) &ut, sizeof(struct utmp), 1, fd) == 1) {
			if ((ut.ut_line[0] != NULL) && (strcmp(tty, ut.ut_line) == 0)) {
				if ((tn = strsave(ut.ut_host)) == NULL)
					break;
				fclose(fd);
				return(tn);
			}
		}
		fclose(fd);
	}
	else
		return(tty);

	return(NULL);
}
